package v1

type WarehouseCreatReq struct {
	SellerId      int     `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"`                //商户id
	Name          string  `json:"name" v:"name@required|length:1,60 #请填写仓库名称|仓库名称长度范围1-60"`                   //仓库名称
	ContactName   string  `json:"contact_name" v:"contact_name@required|length:1,60 #请填写联系人|联系人长度范围1-60"`     //联系人
	ContactTel    string  `json:"contact_tel" v:"contact_tel@required|length:1,30 #请填写联系电话|联系电话长度范围1-30"`     //联系人手机号
	ProvinceId    int     `json:"province_id" v:"province_id@required|integer #请填写地区|请填写正确地区"`                //省id
	CityId        int     `json:"city_id" v:"city_id@required|integer #请填写地区|请填写正确地区"`                        //市id
	DistrictId    int     `json:"district_id" v:"district_id@required|integer #请填写地区|请填写正确地区"`                //区id
	Address       string  `json:"address" v:"address@required|length:1,255 #请填写仓库地址|仓库地址长度范围1-255"`           //仓库地址
	WarehouseArea float64 `json:"warehouse_area" v:"warehouse_area@required|float #请填写仓库面积|仓请填写正确的仓库面积"`      //仓库面积 平方
	IsDefaultGet  int     `json:"is_default_get" v:"is_default_get@required|in:0,1 #请选择是否默认收货仓|请正确填写默认收货仓"`   //是否默认收货仓 0否 1是
	IsDefaultSend int     `json:"is_default_send" v:"is_default_send@required|in:0,1 #请选择是否默认发货仓|请正确填写默认发货仓"` //是否默认收货仓 0否 1是
	Status        int     `json:"status" v:"status@required|in:0,1 #请选择启用状态|请正确填写启用状态"`                       //启用状态 0停用 1启用 2删除
}

type WarehouseInfoRes struct {
	Id 				int `json:"id"`
	SellerId      int     `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"`                //商户id
	Code          string  `json:"code"`                                                                       //仓库编码
	Name          string  `json:"name" v:"name@required|length:1,60 #请填写仓库名称|仓库名称长度范围1-60"`                   //仓库名称
	ContactName   string  `json:"contact_name" v:"contact_name@required|length:1,60 #请填写联系人|联系人长度范围1-60"`     //联系人
	ContactTel    string  `json:"contact_tel" v:"contact_tel@required|length:1,30 #请填写联系电话|联系电话长度范围1-30"`     //联系人手机号
	ProvinceId    int     `json:"province_id" v:"province_id@required|integer #请填写地区|请填写正确地区"`                //省id
	Province      string  `json:"province"`                                                                   //省
	CityId        int     `json:"city_id" v:"city_id@required|integer #请填写地区|请填写正确地区"`                        //市id
	City          string  `json:"city"`                                                                       //市
	DistrictId    int     `json:"district_id" v:"district_id@required|integer #请填写地区|请填写正确地区"`                //区id
	District      string  `json:"district"`                                                                   //区
	Address       string  `json:"address" v:"address@required|length:1,255 #请填写仓库地址|仓库地址长度范围1-255"`           //仓库地址
	WarehouseArea float64 `json:"warehouse_area" v:"warehouse_area@required|float #请填写仓库面积|仓请填写正确的仓库面积"`      //仓库面积平方
	IsDefaultGet  int     `json:"is_default_get" v:"is_default_get@required|in:0,1 #请选择是否默认收货仓|请正确填写默认收货仓"`   //是否默认收货仓 0否 1是
	IsDefaultSend int     `json:"is_default_send" v:"is_default_send@required|in:0,1 #请选择是否默认发货仓|请正确填写默认发货仓"` //是否默认收货仓 0否 1是
	Status        int     `json:"status" v:"status@required|in:0,1 #请选择启用状态|请正确填写启用状态"`                       //启用状态 0停用 1启用 2删除
	CreatedTime   int     `json:"created_time"`                                                               //创建时间
	UpdateTime    int     `json:"update_time"`                                                                //更新时间

}

type WarehouseInfoReq struct {
	Id       int `json:"id" v:"id@required|integer#请填写仓库id|请填写正确的仓库id"`               //仓库id
	SellerId int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` //商户id
}

type WarehouseUpdateReq struct {
	Id            int     `json:"id" v:"id@required|integer#请填写仓库id|请填写正确的仓库id"`                              //仓库id
	SellerId      int     `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"`                //商户id
	Name          string  `json:"name" v:"name@required|length:1,60 #请填写仓库名称|仓库名称长度范围1-60"`                   //仓库名称
	ContactName   string  `json:"contact_name" v:"contact_name@required|length:1,60 #请填写联系人|联系人长度范围1-60"`     //联系人
	ContactTel    string  `json:"contact_tel" v:"contact_tel@required|length:1,30 #请填写联系电话|联系电话长度范围1-30"`     //联系人手机号
	ProvinceId    int     `json:"province_id" v:"province_id@required|integer #请填写地区|请填写正确地区"`                //省id
	CityId        int     `json:"city_id" v:"city_id@required|integer #请填写地区|请填写正确地区"`                        //市id
	DistrictId    int     `json:"district_id" v:"district_id@required|integer #请填写地区|请填写正确地区"`                //区id
	Address       string  `json:"address" v:"address@required|length:1,255 #请填写仓库地址|仓库地址长度范围1-255"`           //仓库地址
	WarehouseArea float64 `json:"warehouse_area" v:"warehouse_area@required|float #请填写仓库面积|仓请填写正确的仓库面积"`      //仓库面积 平方
	IsDefaultGet  int     `json:"is_default_get" v:"is_default_get@required|in:0,1 #请选择是否默认收货仓|请正确填写默认收货仓"`   //是否默认收货仓 0否 1是
	IsDefaultSend int     `json:"is_default_send" v:"is_default_send@required|in:0,1 #请选择是否默认发货仓|请正确填写默认发货仓"` //是否默认收货仓 0否 1是
	Status        int     `json:"status" v:"status@required|in:0,1 #请选择启用状态|请正确填写启用状态"`                       //启用状态 0停用 1启用 2删除
}

type WarehouseListRes struct {
	Count int                `json:"count"` //总数
	List  []WarehouseInfoRes `json:"list"`  //列表
}

type WarehouseListReq struct {
	SellerId int    `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` //商户id
	Name     string `json:"name"`                                                        //仓库名称
	Status   int `json:"status" d:"-1"`        //启用状态 0停用 1启用 2删除
	Code          string  `json:"code"`
	ContactTel    string  `json:"contact_tel"`     //联系人手机号
	ContactName   string  `json:"contact_name"`     //联系人
	Page 			int `json:"page" d:"1"`
	Limit 			int `json:"limit" d: "20"`
}

type WarehouseDeleteReq struct {
	Id       int `json:"id" v:"uid@required|integer#请填写仓库id|请填写正确的仓库id"`              //仓库id
	SellerId int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` //商户id
}
