package v1

type GroupCreatReq struct {
	SellerId 	 	int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` 	 //商户id
	Name 			string `json:"name" v:"name@required|length:1,60 #请填写分组名称|分组名称长度范围1-60"` 	//分组名称
}

type GroupInfoRes struct {
	Id 	 	int `json:"id"` //分组id
	SellerId 	 	int `json:"seller_id"` 	 //商户id
	Name 			string `json:"name"` 	//分组名称
	CreatedTime 	int `json:"created_time"`	//创建时间
	UpdateTime   	int `json:"update_time"`	//更新时间
	IsDel 			int `json:"is_del"` 		//是否删除
	GoodsNum 		int `json:"goods_num"` 		//商品数量
}

type GroupInfoReq struct {
	Id 	 	int `json:"id" v:"id@required|integer#请填写分组id|请填写正确的分组id"` //分组id
	SellerId 	 	int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` 	 //商户id
}

type GroupUpdateReq struct {
	Id 	 			int `json:"id" v:"id@required|integer#请填写分组id|请填写正确的分组id"` //分组id
	SellerId 	 	int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` 	 //商户id
	Name 			string `json:"name" v:"name@required|length:1,60 #请填写分组名称|分组名称长度范围1-60"` 	//分组名称
}

type GroupListRes struct {
	Count int `json:"count"` //总数
	List  []GroupInfoRes `json:"list"` //列表
}

type GroupListReq struct {
	SellerId 	 	int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` 	 //商户id
}

type GroupDeleteReq struct {
	Id 	 	int `json:"id" v:"uid@required|integer#请填写分组id|请填写正确的分组id"` //分组id
	SellerId 	 	int `json:"seller_id" v:"seller_id@required|integer#请填写商户id|请填写正确的商户id"` 	 //商户id
}

