# 收货地址智能解析（Go语言版）

## 1. 基本介绍

### 1.1 功能

> 项目内含2个功能
>
> - 把字符串解析成姓名、电话、邮编、身份证号、收货地址
> - 把收货地址再解析成省、市、区县、街道地址




## 2. 使用说明

```
 golang版本 >= v1.11
```

- Install

  - ```git
    go get gitlab.jxhh.com/zhaoxueru/address.git
    ```

- 使用git克隆本项目

  - ```git
    git clone http://gitlab.jxhh.com/zhaoxueru/address.git
    ```

- 索引树自动生成

  - ```shell-script
    cd /generate
    make all
    如需更新最新的行政信息，请自行修改/data下的json数据然后重新执行一遍以上命令
    ```
  
- 使用Demo
```go
package main

import (
	"fmt"

  addr "gitlab.jxhh.com/zhaoxueru/address.git"
)

func main() {
	parse := addr.Smart("杨锦沂 13987710577 云南曲靖市麒麟区益宁街道办事处水寨6组")

	// 输出解析结果
	fmt.Println(parse.Name)     // 杨锦沂
	fmt.Println(parse.Mobile)   // 13800138000
	fmt.Println(parse.Province) // 云南
	fmt.Println(parse.ProvinceCode) // 25
	fmt.Println(parse.City)     // 曲靖市
	fmt.Println(parse.CityCode)     // 2247
	fmt.Println(parse.Region)   // 麒麟区
	fmt.Println(parse.RegionCode)   // 21034
	fmt.Println(parse.Address)  // 云南曲靖市麒麟区益宁街道办事处水寨6组
}

```

