import request from '@/utils/request'

// 查询order列表
export function listOrder(query) {
    return request({
        url: '/system/order/list',
        method: 'get',
        params: query
    })
}

// 查询order详细
export function getOrder (id) {
    return request({
        url: '/system/order/getInfo?order_id='+id,
        method: 'get'
    })
}

// order发货
export function sendOrder(data) {
    return request({
        url: '/system/order/sendOrder',
        method: 'post',
        data: data
    })
}
//查看物流
export function getExpressInfo(data){
  return request({
      url: '/system/order/getExpressInfo',
      method: 'post',
      data: data
  })
}

// 获取 所有物流信息
export function getExpressList(query) {
  return request({
    url: '/system/order/expressList',
    method: 'get',
    params: query
  })
}

// 新增order
export function addOrder(data) {
    return request({
        url: '/system/order/add',
        method: 'post',
        data: data
    })
}

// 修改order
export function updateOrder(data) {
    return request({
        url: '/system/order/edit',
        method: 'post',
        data: data
    })
}

// 删除order
export function delOrder(ids) {
    return request({
        url: '/system/order/delete',
        method: 'delete',
        data:{ids:ids}
    })
}

// 订单导出
export function exportOrder(query) {
  return request({
    url: '/system/order/batchDeliveryGoodsOut',
    method: 'get',
    params: query
  })
}

// 批量发货
export function deliveryOrder(data) {
  return request({
    url: '/system/order/batchDeliveryGoods',
    method: 'post',
    data: data
  })
}
