import request from '@/utils/request'

// 查询freight列表
export function listFreight(query) {
    return request({
        url: '/system/freight/list',
        method: 'get',
        params: query
    })
}

// 查询freight详细
export function getFreight (id) {
    return request({
        url: '/system/freight/edit?id='+id,
        method: 'get'
    })
}


// 新增freight
export function addFreight(data) {
    return request({
        url: '/system/freight/add',
        method: 'post',
        data: data
    })
}

// 修改freight
export function updateFreight(data) {
    return request({
        url: '/system/freight/edit',
        method: 'post',
        data: data
    })
}

// 删除freight
export function delFreight(ids) {
    return request({
        url: '/system/freight/delete',
        method: 'delete',
        data:{ids:ids}
    })
}

