import request from '@/utils/request'

// 查询asset列表
export function listAsset(query) {
    return request({
        url: '/system/asset/list',
        method: 'get',
        params: query
    })
}

// 查询asset详细
export function getAsset (id) {
    return request({
        url: '/system/asset/edit?id='+id,
        method: 'get'
    })
}


// 新增asset
export function addAsset(data) {
    return request({
        url: '/system/asset/add',
        method: 'post',
        data: data
    })
}

// 修改asset
export function updateAsset(data) {
    return request({
        url: '/system/asset/edit',
        method: 'post',
        data: data
    })
}

// 删除asset
export function delAsset(ids) {
    return request({
        url: '/system/asset/delete',
        method: 'delete',
        data:{ids:ids}
    })
}
