import request from '@/utils/request'
import { praseStrEmpty } from "@/utils/ruoyi";

// 查询用户列表
export function listUser(query) {
  return request({
    url: '/system/auth/userList',
    method: 'get',
    params: query
  })
}

// 查询用户详细
export function getUser() {
  return request({
    url: '/system/auth/addUser',
    method: 'get'
  })
}

// 查询修改用户详细
export function getEditUser(userId) {
  return request({
    url: '/system/auth/editUser?id='+userId,
    method: 'get'
  })
}


// 新增用户
export function addUser(data) {
  return request({
    url: '/system/auth/addUser',
    method: 'post',
    data: data
  })
}

// 修改用户
export function updateUser(data) {
  return request({
    url: '/system/auth/editUser',
    method: 'post',
    data: data
  })
}

// 删除用户
export function delUser(userId) {
  return request({
    url: '/system/auth/deleteAdmin',
    method: 'delete',
    params:{ids:userId}
  })
}

// 导出用户
export function exportUser(query) {
  return request({
    url: '/system/user/export',
    method: 'get',
    params: query
  })
}

// 用户密码重置
export function resetUserPwd(userId, password) {
  const data = {
    userId,
    password
  }
  return request({
    url: '/system/auth/resetUserPwd',
    method: 'put',
    data: data
  })
}

// 用户状态修改
export function changeUserStatus(userId, status) {
  const data = {
    userId,
    status
  }
  return request({
    url: '/system/auth/changeUserStatus ',
    method: 'put',
    data: data
  })
}

// 查询用户个人信息
export function getUserProfile() {
  return request({
    url: '/system/user/profile',
    method: 'get'
  })
}

// 修改用户个人信息
export function updateUserProfile(data) {
  return request({
    url: '/system/user/edit',
    method: 'post',
    data: data
  })
}

// 用户密码重置
export function updateUserPwd(oldPassword, newPassword) {
  const data = {
    oldPassword,
    newPassword
  }
  return request({
    url: '/system/user/updatePwd',
    method: 'post',
    data: data
  })
}

// 用户头像上传
export function uploadAvatar(data) {
  return request({
    url: '/system/user/avatar',
    method: 'post',
    data: data
  })
}


// 下载用户导入模板
export function importTemplate() {
  return request({
    url: '/system/user/importTemplate',
    method: 'get'
  })
}

export function getBaseSettingTitle(params) {
  return request({
    url: '/system/oem/getBaseSettingTitle',
    method: 'get',
    params
  })
}
