import request from '@/utils/request'

// 查询verifyrecord列表
export function listVerifyrecord(query) {
    return request({
        url: '/system/verifyrecord/list',
        method: 'get',
        params: query
    })
}

// 查询verifyrecord详细
export function getVerifyrecord (id) {
    return request({
        url: '/system/verifyrecord/getDetail?id='+id,
        method: 'get'
    })
}

// 自动对账接口
export function autoVerifyAccount(data) {
    return request({
        url: '/system/verifyrecord/autoVerifyAccount',
        method: 'post',
        data: data
    })
}

// 新增verifyrecord
export function addVerifyrecord(data) {
    return request({
        url: '/system/verifyrecord/add',
        method: 'post',
        data: data
    })
}

// 修改verifyrecord
export function updateVerifyrecord(data) {
    return request({
        url: '/system/verifyrecord/edit',
        method: 'post',
        data: data
    })
}

// 删除verifyrecord
export function delVerifyrecord(ids) {
    return request({
        url: '/system/verifyrecord/delete',
        method: 'delete',
        data:{ids:ids}
    })
}
