import request from '@/utils/request'

// 查询goods列表(上架,下架)
export function listGoods(query) {
    return request({
        url: '/system/goods/list',
        method: 'get',
        params: query
    })
}

// 查询类别
export function GetCategory(query) {
    return request({
        url: '/system/goods/getCategory',
        method: 'get',
        params: query
    })
}
// 查询运费模板
export function GetFreight(query) {
    return request({
        url: '/system/goods/getFreight',
        method: 'get',
        params: query
    })
}
// 查询goods详细
export function getGoods (id) {
    return request({
        url: '/system/goods/edit?goodsId='+id,
        method: 'get'
    })
}
//上架商品
export function Onsale(data) {
    return request({
        url: '/system/goods/onSale',
        method: 'post',
        data: data
    })
}

// 新增goods
export function addGoods(data) {
    return request({
        url: '/system/goods/add',
        method: 'post',
        data: data
    })
}

// 修改goods
export function updateGoods(data) {
    return request({
        url: '/system/goods/edit',
        method: 'post',
        data: data
    })
}

// 删除goods
export function delGoods(ids) {
    return request({
        url: '/system/goods/delete',
        method: 'delete',
        data:{ids:ids}
    })
}
//上传图片
export function UploadImg(data) {
    return request({
        url: '/system/goods/uploadImg',
        method: 'post',
        data: data
    })
}
