import request from '@/utils/request';

// 修改手机号
export function changeTelphone(data) {
  return request({
    url: '/local/seller/editMobile',
    method: 'post',
    data: data
  })
}

// 设置登录密码
export function changeLoginPassword(data) {
  return request({
    url: '/local/seller/setPass',
    method: 'post',
    data: data
  })
}

// 设置支付密码
export function changePayPassword(data) {
  return request({
    url: '/local/seller/setPayPass',
    method: 'post',
    data: data
  })
}

// 获取验证码 有两个接口
// 1-修改登录账号/密码，获取验证码
export function getTelphoneCode(id) {
  return request({
    url: '/local/seller/sendCodeMobile?mobile=' + id,
    method: 'get'
  })
}
// 2-修改 支付密码，获取验证码
export function getEditPayPasswordCode(query) {
  return request({
    url: '/local/seller/sendMobile',
    method: 'get',
    params: query
  })
}
//获取商品计量单位列表
export function goodsUnitList(query){
  return request({
    url: '/local/goodsUnit/getList',
    method: 'get',
    params: query
  })
}
//删除计量单位列表
export function delGoodsUnit(data){
  return request({
    url: '/local/goodsUnit/del',
    method: 'post',
    data: data
  })
}
//新增计量单位
export function addGoodsUnit(data){
  return request({
    url: '/local/goodsUnit/operation',
    method: 'post',
    data: data
  })
}
// 计量单位编辑
export function updateGoodsUnit(data){
  return request({
    url: '/local/goodsUnit/info',
    method: 'post',
    data: data
  })
}
//获取商品单位列表
export function getPackList(query){
  return request({
    url: '/local/goodsUnit/getPackList',
    method: 'get',
    params: query
  })
}
//删除包装单位列表
export function delPack(data){
  return request({
    url: '/local/goodsUnit/delPack',
    method: 'post',
    data: data
  })
}
//新增包装单位
export function addPack(data){
  return request({
    url: '/local/goodsUnit/operationPack',
    method: 'post',
    data: data
  })
}
// 包装单位编辑
export function infoPack(data){
  return request({
    url: '/local/goodsUnit/infoPack',
    method: 'post',
    data: data
  })
}
//获取商品物流
export function goodsLogistics(query){
  return request({
    url: '/local/goodsLogistics/getList',
    method: 'get',
    params: query
  })
}
//删除快递公司名称
export function delGoodsLogistics(data){
  return request({
    url: '/local/goodsLogistics/del',
    method: 'post',
    data: data
  })
}
//新增快递公司
export function addGoodsLogistics(data){
  return request({
    url: '/local/goodsLogistics/add',
    method: 'post',
    data: data
  })
}
//获取商品分组列表
export function groupList(data){
  return request({
    url: '/local/group/list',
    method: 'post',
    data: data
  })
}
//创建商品分组
export function addGroup(data){
  return request({
    url: '/local/group/create',
    method: 'post',
    data: data
  })
}
//编辑商品分组
export function updateGroup(data){
  return request({
    url: '/local/group/update',
    method: 'post',
    data: data
  })
}
//编辑商品分组
export function GroupInfo(data){
  return request({
    url: '/local/group/info',
    method: 'post',
    data: data
  })
}
//删除商品分组
export function deleteGroup(data){
  return request({
    url: '/local/group/delete',
    method: 'post',
    data: data
  })
}
// 获取 所有物流信息
export function getExpressListData(query) {
  return request({
    url: '/system/order/expressList',
    method: 'get',
    params: query
  })
}

