import request from '@/utils/request'

// 查询bankcard列表
// export function listBankcard(query) {
//     return request({
//         url: '/system/bankcard/list',
//         method: 'get',
//         params: query
//     })
// }
// 查询银行名称列表
// export function listBankname(query) {
//     return request({
//         url: '/system/bankcard/getBankList',
//         method: 'get',
//         params: query
//     })
// }

// 查询bankcard详细
// export function getBankcard (id) {
//     return request({
//         url: '/system/bankcard/edit?id='+id,
//         method: 'get'
//     })
// }


// 修改bankcard
// export function updateBankcard(data) {
//     return request({
//         url: '/system/bankcard/edit',
//         method: 'post',
//         data: data
//     })
// }

// 删除bankcard
// export function delBankcard(ids) {
//     return request({
//         url: '/system/bankcard/delete',
//         method: 'delete',
//         data:{id:ids}
//     })
// }

// 我的资产 页面 所有数据
export function getMyAssetListData(data) {
  return request({
    url: '/local/assets/list',
    method: 'post',
    data: data
  })
}

// 获取 主体信息
export function getOrganizationData(query) {
    return request({
        url: '/local/getOrganization',
        method: 'get',
        params: query
    })
}

// 新增 银行卡 信息
export function addBankcardData(data) {
    return request({
        url: '/system/bank/add',
        method: 'post',
        data: data
    })
}

// 编辑 银行卡 信息
export function editBankcardData(data) {
  return request({
    url: '/system/bank/update',
    method: 'post',
    data: data
  })
}

// 获取 银行卡 详情
export function getBankDetailsData(data) {
  return request({
    url: '/system/bank/detail',
    method: 'post',
    data: data
  })
}

// 获取商户银行卡列表
export function getBankcardListData(data) {
  return request({
    url: '/system/bank/list',
    method: 'post',
    data: data
  })
}

// 账户 删除
export function delBankcardData(data) {
  return request({
    url: '/system/bank/delete',
    method: 'post',
    data: data
  })
}

// 收支明细 列表
export function getBalanceList(data) {
  return request({
    url: '/local/asset/getSellerBalanceLogList',
    method: 'post',
    data: data
  })
}

// 提现记录 列表
export function getWithdrawData(data) {
  return request({
    url: '/system/withdrawlog/list',
    method: 'post',
    data: data
  })
}

// 提现记录 详情
export function getWithdrawlogDetailsData(data) {
  return request({
    url: '/system/withdrawlog/info',
    method: 'post',
    data: data
  })
}

// 导出商品明细
export function exportGoodsDetailsData(data) {
  return request({
    url: '/system/withdrawlog/exportWithdrawOrderGoods',
    method: 'post',
    data: data
  })
}

// 获取 所有物流信息
export function getExpressListData(query) {
  return request({
    url: '/system/order/expressList',
    method: 'get',
    params: query
  })
}

// 上传 发票 图片
export function upLoadImg (data) {
  return request({
    url: '/system/goodsNew/uploadImage',
    method: 'post',
    data: data
  });
}

// 补充发票
export function addInvoiceData (data) {
  return request({
    url: '/system/withdrawlog/updateInvoice',
    method: 'post',
    data: data
  });
}

// 获取验证码
export function getCheckCodeData(data) {
  return request({
    url: '/system/withdrawlog/getCheckCode',
    method: 'post',
    data: data
  })
}

// 提交 提现申请
export function applyWithdraw(data) {
  return request({
    url: '/system/withdrawlog/applyWithdraw',
    method: 'post',
    data: data
  })
}

