import router from './router'
import store from './store'
import { Message } from 'element-ui'
import NProgress from 'nprogress'
import 'nprogress/nprogress.css'
import { getToken } from '@/utils/auth'
import getPageTitle from '@/utils/get-page-title'

NProgress.configure({ showSpinner: false })

const whiteList = ['/login','/platformlogin','/', '/auth-redirect', '/bind', '/register']

router.beforeEach((to, from, next) => {
  debugger
  NProgress.start()
  const hasToken = getToken()
  // console.log("getToken()",getToken())
  if (hasToken) {
    if (sessionStorage.getItem('saveTitle')) {
      document.title = sessionStorage.getItem('saveTitle')
    } else {
      getPageTitle()
    }

    /* has token*/
    if (to.path === '/platformlogin') {
      next({ path: '/home/index' })
      NProgress.done()
    } else {
      if (store.getters.roles.length === 0) {
        //debugger
        // 判断当前用户是否已拉取完user_info信息
        store.dispatch('GetInfo').then(res => {
          // 拉取user_info
          const roles = res.data.roles
          // debugger
          const userInfo = res.data.user
          store.dispatch('GenerateRoutes', { roles }).then(accessRoutes => {
            // 根据roles权限生成可访问的路由表
            router.addRoutes(accessRoutes)
            // debugger
            if (userInfo.state == 1) {
              next({ ...to, replace: true }) // hack方法 确保addRoutes已完成
            } else if (userInfo.state == 2){
              next({path:'/reviewing',replace: true});
            } else if (userInfo.state == 0){
              if (userInfo.status == 0) {
                next({path:'/process',replace: true});
              }else if (userInfo.status == 1) {
                next({path:'/fillShopInf',replace: true});
              }
            } else if (userInfo.state == 3) {
              next({path:'/reviewFail',replace: true,params: {...to.params.msg}});
            }
          })
        }).catch(err => {
            store.dispatch('FedLogOut').then(() => {
              Message.error(err)
              next({ path: '/home/index' })
            })
          })
      } else {
        next()
        // 没有动态改变权限的需求可直接next() 删除下方权限判断 ↓
        // if (hasPermission(store.getters.roles, to.meta.roles)) {
        //   next()
        // } else {
        //   next({ path: '/401', replace: true, query: { noGoBack: true }})
        // }
        // 可删 ↑
      }
    }
  } else {
    // 没有token
    // 在免登录白名单，直接进入
    if (whiteList.indexOf(to.path) !== -1) {
      // 在免登录白名单，直接进入
      next()
    } else {
      next(`/login?redirect=${to.path}`) // 否则全部重定向到登录页
      NProgress.done()
    }
  }
})

router.afterEach(() => {
  NProgress.done()
})
