import { login, login2,logout, getInfo, getStatistics } from '@/api/login'
import { getssoUrl } from '@/api/webSite'
import { getToken, setToken, removeToken } from '@/utils/auth'

const user = {
  state: {
    token: getToken(),
    name: '',
    avatar: '',
    sellerid:0,
    roles: [],
    permissions: [],
    ssourl:''
  },

  mutations: {
    SET_SSOURL:(state,ssourl)=>{
      state.ssourl = ssourl
    },
    SET_TOKEN: (state, token) => {
      state.token = token
    },
    SET_NAME: (state, name) => {
      state.name = name
    },
    SET_SELLERID: (state, sellerid) => {
      state.sellerid = sellerid
    },
    SET_AVATAR: (state, avatar) => {
      state.avatar = avatar
    },
    SET_ROLES: (state, roles) => {
      state.roles = roles
    },
    SET_PERMISSIONS: (state, permissions) => {
      state.permissions = permissions
    }
  },

  actions: {
    getssourl({commit},data){
      return new Promise((resolve, reject) => {
        getssoUrl(data).then(response => {
          const date = response.data
          //debugger
          if (response.code == 1) {
            commit('SET_SSOURL', date.access_token)
          }
          resolve(response)
        }).catch(error => {
          reject(error)
        })
      })
    },
    // 新登录
    // oLDLogin({ commit }, userInfo) {
    //   const username = userInfo.username.trim()
    //   const password = userInfo.password
    //   const code = userInfo.code
    //   const uuid = userInfo.uuid
    //   return new Promise((resolve, reject) => {
    //     login(username, password, code, uuid).then(res => {
    //       setToken(res.data.token)
    //       commit('SET_TOKEN', res.data.token)
    //       resolve()
    //     }).catch(error => {
    //       reject(error)
    //     })
    //   })
    // },
    // 登录
    Login({ commit }, tickets) {
      const ticket = tickets.ticket
      return new Promise((resolve, reject) => {
        login2(tickets).then(res => {
          setToken(res.data.token)
          commit('SET_TOKEN', res.data.token)
          resolve(res.data)
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 获取用户信息
    GetInfo({ commit, state }) {
      return new Promise((resolve, reject) => {
        getInfo().then(res => {
          //debugger
          const user = res.data.user
          // const avatar = user.avatar == "" ? require("@/assets/image/login-background.jpg") : process.env.VUE_APP_BASE_API +"/"+ user.avatar;
          const avatar = require("@/assets/image/login-background.jpg")
          if (res.data.roles && res.data.roles.length > 0) { // 验证返回的roles是否是一个非空数组
            commit('SET_ROLES', res.data.roles)
            commit('SET_PERMISSIONS', res.data.permissions)
          } else {
            commit('SET_ROLES', ['ROLE_DEFAULT'])
          }
          commit('SET_NAME', user.Username)
          commit('SET_SELLERID', user.SellerId)
          commit('SET_AVATAR', avatar)
          resolve(res)
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 退出系统
    LogOut({ commit, state }) {
      return new Promise((resolve, reject) => {
        logout().then(() => {
          commit('SET_TOKEN', '')
          commit('SET_ROLES', [])
          commit('SET_PERMISSIONS', [])

          removeToken()
          var ssa = window.location.host
            // setTimeout(function (){
            //  if(ssa =='localhost:1024'){
            //    window.location.href='http://sso.jxhh.com/logout?redirect=http://'+ssa
            //  }else{
            //   window.location.href='http://sso.jxhh.com/logout?redirect=http://'+ssa
            //  }
            // }, 1000)

          resolve()
        }).catch(error => {
          reject(error)
        })
      })
    },

    // 前端 登出
    FedLogOut({ commit }) {
      return new Promise(resolve => {
        commit('SET_TOKEN', '')
        removeToken()
        resolve()
      })
    }
  }
}

export default user
