import request from '@/utils/request';

// 获取 售后地址列表
export function getAddressList(query) {
  return request({
    url: '/local/shopRefundAddress/list',
    method: 'get',
    params: query
  });
}

// 新增/修改售后地址
export function addAddress(data) {
  return request({
    url: '/local/shopRefundAddress/add',
    method: 'post',
    data: data
  })
}

// 获取售后地址详情
export function getAddressDetails (id) {
  return request({
    url: '/local/getRefundAddressInfo?id='+id,
    method: 'get'
  })
}

// 删除售后地址
export function deleteAddress (id) {
  return request({
    url: '/local/delRefundAddress?id='+id,
    method: 'get'
  })
}

// 获取省市区地址
export function getAreaList(query) {
  return request({
    url: '/local/provinceCity/list',
    method: 'get',
    params: query
  });
}


//
