import request from '@/utils/request';
// 获取用户详细信息
export function getInfo(param) {
  return request({
    url: '/system/index/getInfo',
    method: 'get',
    params: param
  })
}

// 获取主体信息
export function getMainInf(query) {
  return request({
    url: '/local/getOrganization',
    method: 'get',
    params: query
  });
}

// 新建主体信息
export function addMain(data) {
  return request({
    url: '/local/organization',
    method: 'post',
    data: data
  })
}
// 获取品牌信息
export function getBrandsInf(query) {
  return request({
    url: '/local/shopbrand',
    method: 'get',
    params: query
  });
}

// 新建品牌信息
export function addBrands(data) {
  return request({
    url: '/local/brands',
    method: 'post',
    data: data
  });
}
// 修改品牌信息
export function upBrands(data) {
  return request({
    url: '/local/upbrands',
    method: 'post',
    data: data
  });
}

// 获取店铺信息
export function getShopInf(query) {
  return request({
    url: '/local/getShopInfo',
    method: 'get',
    params: query
  });
}
// 提交店铺信息
export function addShopInf(data) {
  return request({
    url: '/local/addShopInfo',
    method: 'post',
    data: data
  });
}

// 上传图片
export function upLoadImg (data) {
  return request({
    url: '/system/goodsNew/uploadImage',
    method: 'post',
    data: data
  });
}

// 获取商品类目
export function getGoodsType(query) {
  return request({
    url: '/local/cate',
    method: 'get',
    params: query
  });
}

// 营业执照 图片识别信息
export function getLicenseImgInfoData(query) {
  return request({
    url: '/local/check/businessLicense',
    method: 'get',
    params: query
  });
}

// 身份证 正/反 图片识别信息
export function getIdcardImgInfoData(query) {
  return request({
    url: '/local/check/idCard',
    method: 'get',
    params: query
  });
}

// 查询 入驻类目资质
export function getUploadQualificationListData(query) {
  return request({
    url: '/local/qualification/list',
    method: 'get',
    params: query
  });
}
