import request from '@/utils/request'

// 查询order列表
export function listOrder(query) {
    return request({
        url: '/system/order/getOrderList',
        method: 'get',
        params: query
    })
}

// 查询order详细
export function orderInfo (query) {
    return request({
        url: '/system/order/getOrderInfo',
        method: 'get',
        params: query
    })
}

// order发货
export function sendOrder(data) {
    return request({
        url: '/system/order/sendOrde',
        method: 'post',
        data: data
    })
}

//查看物流
export function expressInfoNew(params){
  return request({
      url: '/system/order/getExpressInfoNew',
      method: 'get',
      params
  })
}

// 修改订单收货信息
export function orderInfoEdit(data){
  return request({
      url: '/system/order/orderInfoEdit',
      method: 'post',
      data: data
  })
}

//订单备注
export function remarkOrder(data){
  return request({
      url: '/system/order/remarkOrder',
      method: 'post',
      data: data
  })
}

// 获取 所有物流信息
export function expressList(query) {
  return request({
    url: '/system/order/expressList',
    method: 'get',
    params: query
  })
}

// 新增order
export function addOrder(data) {
    return request({
        url: '/system/order/add',
        method: 'post',
        data: data
    })
}

// 修改order
export function updateOrder(data) {
    return request({
        url: '/system/order/edit',
        method: 'post',
        data: data
    })
}

// 删除order
export function delOrder(ids) {
    return request({
        url: '/system/order/delete',
        method: 'delete',
        data:{ids:ids}
    })
}

// 订单导出
export function exportOrder(query) {
  return request({
    url: '/system/order/batchDeliveryGoodsOut',
    method: 'get',
    params: query
  })
}

// 批量发货
export function deliveryOrder(data) {
  return request({
    url: '/system/order/batchDeliveryGoods',
    method: 'post',
    data: data
  })
}
