import request from '@/utils/request'

// 获取店铺信息
export const shopInfo = () => {
  return request({
    url: '/local/getShopInfo',
    method: 'get'
  })
}

// 获取交易流水
export const bondDetail = (params) => {
  return request({
    url: '/local/shop/bond/detail',
    method: 'get',
    params
  })
}

// 充值保证金
export const addBond = (data) => {
  return request({
    url: '/system/addBond',
    method: 'post',
    data
  })
}

// 保证金额度说明
export const bondByCate = (params) => {
  return request({
    url: '/local/getBondByCate',
    method: 'get',
    params
  })
}

// 账户/列表
export const accountList = (data) => {
  return request({
    url: '/system/bank/account/list',
    method: 'post',
    data
  })
}

// 申请退保
export const bondApply = (data) => {
  return request({
    url: '/local/bondApply',
    method: 'post',
    data
  })
}

// 获取支付账户
export const payDetails = (params) => {
  return request({
    url: '/system/payDetails',
    method: 'get',
    params
  })
}

// 保证金申请详情
export const applyDetail = (params) => {
  return request({
    url: '/local/bond/apply/detail',
    method: 'get',
    params
  })
}

