import request from '@/utils/request'

// 查询bankcard列表
export function listBankcard(query) {
    return request({
        url: '/system/bankcard/list',
        method: 'get',
        params: query
    })
}
// 查询银行名称列表
export function listBankname(query) {
    return request({
        url: '/system/bankcard/getBankList',
        method: 'get',
        params: query
    })
}

// 查询bankcard详细
export function getBankcard (id) {
    return request({
        url: '/system/bankcard/edit?id='+id,
        method: 'get'
    })
}


// 新增bankcard
export function addBankcard(data) {
    return request({
        url: '/system/bankcard/add',
        method: 'post',
        data: data
    })
}

// 修改bankcard
export function updateBankcard(data) {
    return request({
        url: '/system/bankcard/edit',
        method: 'post',
        data: data
    })
}

// 删除bankcard
export function delBankcard(ids) {
    return request({
        url: '/system/bankcard/delete',
        method: 'delete',
        data:{id:ids}
    })
}
