import request from '@/utils/request';

// 获取主体信息
export function getMainInf(query) {
  return request({
    url: '/local/getOrganization',
    method: 'get',
    params: query
  });
}

// 新建主体信息
export function addMain(data) {
  return request({
    url: '/local/organization',
    method: 'post',
    data: data
  })
}
// 获取品牌信息
export function getBrandsInf(query) {
  return request({
    url: '/local/shopbrand',
    method: 'get',
    params: query
  });
}

// 新建品牌信息
export function addBrands(data) {
  return request({
    url: '/local/brands',
    method: 'post',
    data: data
  });
}
// 修改品牌信息
export function upBrands(data) {
  return request({
    url: '/local/upbrands',
    method: 'post',
    data: data
  });
}

// 获取店铺信息
export function getShopInf(query) {
  return request({
    url: '/local/getShopInfo',
    method: 'get',
    params: query
  });
}
// 提交店铺信息
export function addShopInf(data) {
  return request({
    url: '/local/addShopInfo',
    method: 'post',
    data: data
  });
}

// 上传图片
export function upLoadImg (data) {
  return request({
    url: '/system/goodsNew/uploadImage',
    method: 'post',
    data: data
  });
}

// old
// export function upLoadImg (data) {
//   return request({
//     url: '/system/goods/uploadImg',
//     method: 'post',
//     data: data
//   });
// }
// 获取商品类目
export function getGoodsType(query) {
  return request({
    url: '/local/cate',
    method: 'get',
    params: query
  });
}
