import request from '@/utils/request'

// 查询withdrawlog列表
export function listWithdrawlog(query) {
    return request({
        url: '/system/withdrawlog/list',
        method: 'get',
        params: query
    })
}

// 查询bank详细
export function getBankcard (id) {
    return request({
        url: '/system/bankcard/edit?id='+id,
        method: 'get'
    })
}

// 查询withdrawlog详细
export function getWithdrawlog (id) {
    return request({
        url: '/system/withdrawlog/edit?id='+id,
        method: 'get'
    })
}


// // 新增withdrawlog
// export function addWithdrawlog(data) {
//     return request({
//         url: '/system/withdrawlog/add',
//         method: 'post',
//         data: data
//     })
// }

// 修改withdrawlog
export function updateWithdrawlog(data) {
    return request({
        url: '/system/withdrawlog/edit',
        method: 'post',
        data: data
    })
}

// 删除withdrawlog
export function delWithdrawlog(ids) {
    return request({
        url: '/system/withdrawlog/delete',
        method: 'delete',
        data:{ids:ids}
    })
}

// 获取商户信息
export function getSellerInfo(data) {
   return request({
       url: '/system/withdrawlog/getSellerInfo',
       method: 'post',
       data: data
   })
}

// 获取商户银行卡列表
export function getBankcardList(query) {
    return request({
        url: '/system/bankcard/list',
        method: 'get',
        params: query
    })
}
// 获取验证码
export function getCheckCode(data) {
    return request({
       url: '/system/withdrawlog/getCheckCode',
       method: 'post',
       data: data
    })
}
// 提交提现信息
export function addWithdrawlog(data) {
    return request({
       url: '/system/withdrawlog/doReflect',
       method: 'post',
       data: data
    })
}
