import request from '@/utils/request'

// 同意售后申请
export function refundagreeat(data) {
    return request({
        url: '/system/retreat/refundAgree',
        method: 'post',
        data: data
    })
}


// 拒绝售后申请
export function refundReject(data) {
    return request({
        url: '/system/retreat/refundReject',
        method: 'post',
        data: data
    })
}


// 查询retreat列表
export function listRetreat(query) {
    return request({
        url: '/system/retreat/list',
        method: 'get',
        params: query
    })
}

// 查询retreat详细
export function getRetreat (id) {
    return request({
        url: '/system/retreat/edit?order_refund_sn='+id,
        method: 'get'
    })
}


// 提交retreat
export function retreatSubmit(data) {
    return request({
        url: '/system/retreat/retreatSubmit',
        method: 'post',
        data: data
    })
}

// 获取售后类型，等
export function getSearchParams(query) {
  return request({
    url: '/system/retreat/getSearchParams',
    method: 'get',
    params: query
  })
}
// // 修改retreat
// export function updateRetreat(data) {
//     return request({
//         url: '/system/retreat/edit',
//         method: 'post',
//         data: data
//     })
// }

// // 删除retreat
// export function delRetreat(ids) {
//     return request({
//         url: '/system/retreat/delete',
//         method: 'delete',
//         data:{ids:ids}
//     })
// }

// 售后列表
export function getRetreatList(query) {
  return request({
    url: '/system/retreat/list',
    method: 'get',
    params: query
  })
}

// 详情
export function getASOrderDetail(query) {
  return request({
    url: '/system/retreat/edit',
    method: 'get',
    params: query
  })
}

// 售后 同意类操作
export function agreeRefundData(data) {
  return request({
    url: '/system/retreat/refundAgree',
    method: 'post',
    data: data
  })
}

// 售后 拒绝类 操作
export function refuseRefundData(data) {
  return request({
    url: '/system/retreat/refundReject',
    method: 'post',
    data: data
  })
}

// 退货退款  地址
export function getASAdressData(query) {
  return request({
    url: '/local/AfterSalesAddress/list',
    method: 'get',
    params: query
  })
}

// 获取 售后 tab 数量
export function getTabCountData(data) {
  return request({
    url: '/system/retreat/refundListTopNum',
    method: 'post',
    data: data
  })
}
