import request from '@/utils/request';
// 获取品牌列表
export function getBrandsInf(query) {
  return request({
    url: '/local/brands',
    method: 'get',
    params: query
  });
}

// 新增品牌
export function addBrand(data) {
  return request({
    url: '/local/brands',
    method: 'post',
    data: data
  });
}

// 获取品牌详情
export function getDetails (id) {
  return request({
    url: '/local/brandsInfo?id='+id,
    method: 'get'
  })
}

// 修改品牌信息
export function upBrand(data) {
  return request({
    url: '/local/upbrands',
    method: 'post',
    data: data
  });
}

// 上传图片 old
// export function upLoadImg (data) {
//   return request({
//     url: '/system/goods/uploadImg',
//     method: 'post',
//     data: data
//   });
// }
// new
export function upLoadImg (data) {
  return request({
    url: '/system/goodsNew/uploadImage',
    method: 'post',
    data: data
  });
}
