import request from '@/utils/request'

// 查询goods列表(上架,下架)
export function listGoods(query) {
    return request({
        url: '/system/goods/list',
        method: 'get',
        params: query
    })
}

// 上传视频
export function uploadVideo(data) {
  return request({
      url: '/system/goods/uploadVideo',
      method: 'post',
      data: data
  })
}
// 查询类别
export function GetCategory(query) {
    return request({
        url: '/system/goods/getCategory',
        method: 'get',
        params: query
    })
}

// 经营类目-12-23-bak
export function NewGetCategory(query) {
  return request({
    url: 'goodsNew/BusinessList',
    method: 'get',
    params: query
  })
}


// 营业类目
export function NewGetCategoryDataall(query) {
  return request({
    url: 'system/goodsNew/businessList',
    method: 'get',
    params: query
  })
}
// 营业类目动态获取
export function NewGetCategoryData(data) {
  return request({
    url: '/local/getCategoryList',
    method: 'post',
    data: data
  })
}
// 查询运费模板
export function GetFreight(query) {
    return request({
        url: '/system/freightNew/getFreight',
        method: 'get',
        params: query
    })
}
// 查询goods详细
export function getGoods (id) {
    return request({
        url: '/system/goods/edit?goodsId='+id,
        method: 'get'
    })
}
//上架商品
export function Onsale(data) {
    return request({
        url: '/system/goods/onSale',
        method: 'post',
        data: data
    })
}

// 新增goods - old
// export function addGoods(data) {
//     return request({
//         url: '/system/goods/add',
//         method: 'post',
//         data: data
//     })
// }

// 新增商品
export function addGoods(data) {
    return request({
        url: '/system/goodsNew/addGoods',
        method: 'post',
        data: data
    })
}

// 查询商品详情
export function getGoodsNew(data) {
  return request({
    url: '/system/goodsNew/info',
    method: 'post',
    data: data
  })
}

// 商品编辑 new
export function updateGoodsNew(data) {
  return request({
    url: '/system/goodsNew/goodsEdit',
    method: 'post',
    data: data
  })
}

// 修改goods
export function updateGoods(data) {
    return request({
        url: '/system/goods/edit',
        method: 'post',
        data: data
    })
}

// 删除goods
export function delGoods(ids) {
    return request({
        url: '/system/goods/delete',
        method: 'delete',
        data:{ids:ids}
    })
}
//上传图片
export function UploadImg(data) {
    return request({
        url: '/system/goodsNew/uploadImage',
        method: 'post',
        data: data
    })
}

// 批量上传图片
export function batchUploadImage(data) {
  return request({
      url: '/system/goodsNew/batchUploadImage',
      method: 'post',
      data: data
  })
}

// 根据类目 获取服务费
export function getByCategoryData(query) {
  return request({
    url: '/local/serviceFee/getByCategory',
    method: 'get',
    params: query
  })
}

// 综合列表-仓库-供应商-计量单位。。。
export function synthesisList(data) {
  return request({
    url: '/system/goodsNew/synthesisList',
    method: 'post',
    data: data
  })
}
//商品复制
export function goodsNewcopy(query) {
  return request({
    url: '/system/goodsNew/copy',
    method: 'get',
    params: query
  })
}
