import request from '@/utils/request'

// 可开发票列表
export function invoiceListStatics(params) {
  return request({
    url: '/receipt/openOrderList',
    method: 'get',
    params
  })
}

// 可开发票-订单详情
export function orderListInvo(params) {
  return request({
    url: '/receipt/orderList',
    method: 'get',
    params
  })
}

// 可开发票-订单详情-导出列表
export function getOrderListExport(params) {
  return request({
    url: '/receipt/orderListExport',
    method: 'get',
    params
  })
}

// 可开发票-申请开票-发票抬头
export function receipt(params) {
  return request({
    url: '/operate/receipt/getReceipt',
    method: 'get',
    params
  })
}

// 可开发票-申请开票-保存发票抬头
export function updateReceipt(data) {
  return request({
    url: '/operate/receipt/updateReceipt',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-领取方式
export function addressList(params) {
  return request({
    url: '/operate/receipt/getAddressList',
    method: 'get',
    params
  })
}

// 可开发票-申请开票-领取方式-设为默认
export function setAddress(data) {
  return request({
    url: '/operate/receipt/setAddress',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-领取方式-编辑
export function updateAddress(data) {
  return request({
    url: '/operate/receipt/updateAddress',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-领取方式-删除
export function delAddress(data) {
  return request({
    url: '/operate/receipt/delAddress',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-领取方式-添加
export function addAddress(data) {
  return request({
    url: '/operate/receipt/addAddress',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-提交开票
export function saveReceipt(data) {
  return request({
    url: '/receipt/invoice',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-去支付
export function createReceipt(data) {
  return request({
    url: '/receipt/createReceipt',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-验证是否设置密码
export function accountSafePwd(params) {
  return request({
    url: '/accountSafePwd',
    method: 'get',
    params
  })
}

// 可开发票-申请开票-余额支付
export function notifyReceipt(data) {
  return request({
    url: '/receipt/balanceNotify',
    method: 'post',
    data
  })
}

// 可开发票-申请开票-支付宝支付
export function pay(data) {
  return request({
    url: '/receipt/pay',
    method: 'post',
    data
  })
}

// 支付验证
export function checkNotify(params) {
  return request({
    url: '/checkNotify',
    method: 'get',
    params
  })
}

// 开票记录列表
export function invoiceList(params) {
  return request({
    url: '/invoicesmanagement/invoiceList',
    method: 'get',
    params
  })
}

// 开票记录-发票详情
export function invoiceInfo(params) {
  return request({
    url: '/invoicesmanagement/getInvoiceInfo',
    method: 'get',
    params
  })
}

// 【new】发票用户信息详情
export function receiptUserInfo(params) {
  return request({
    url: '/receipt/receiptUserInfo',
    method: 'get',
    params
  })
}

// 【new】发票用户信息编辑
export function addUserReceiptInfo(data) {
  return request({
    url: '/receipt/receiptUserInfoEdit',
    method: 'post',
    data
  })
}


