package wangdiantong

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	jsoniter "github.com/json-iterator/go"
)

type SalesRefundPushReq struct {
	Tid           string             `json:"tid"`
	ShopNo        string             `json:"shop_no"`
	PlatformId    int                `json:"platform_id"`
	RefundNo      string             `json:"refund_no"`
	Type          int                `json:"type"`
	Status        string             `json:"status"`
	RefundFee     float64            `json:"refund_fee"`
	BuyerNick     string             `json:"buyer_nick"`
	RefundTime    string             `json:"refund_time"`
	Reason        string             `json:"reason"`
	Desc          string             `json:"desc"`
	RefundVersion string             `json:"refund_version"`
	LogisticsNo   string             `json:"logistics_no"`
	LogisticsName string             `json:"logistics_name"`
	OrderList     []*RefundOrderList `json:"order_list"`
}

type RefundOrderList struct {
	Oid string `json:"oid"`
	Num int    `json:"num"`
}

type SalesRefundPushRes struct {
	Code     int    `json:"code"`
	Message  string `json:"message"`
	ChgCount int    `json:"chg_count"`
	NewCount int    `json:"new_count"`
}

/*
*
创建原始退款单
*/
func (s *WangDianTong) SalesRefundPush(ctx context.Context, req *SalesRefundPushReq) (res *SalesRefundPushRes, err error) {
	salesRefundPushReqs := []*SalesRefundPushReq{}
	salesRefundPushReqs = append(salesRefundPushReqs, req)
	params := make(map[string]interface{})
	json, _ := jsoniter.MarshalToString(salesRefundPushReqs)
	params["api_refund_list"] = json
	result, err := s.post(ctx, "/openapi2/sales_refund_push.php", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type RefundQueryReq struct {
	StartTime   string `json:"start_time"`
	EndTime     string `json:"end_time"`
	PageSize    string `json:"page_size"`
	PageNo      string `json:"page_no"`
	Tid         string `json:"tid"`
	LogisticsNo string `json:"logistics_no"`
	SrcRefundNo string `json:"src_refund_no"`
	RefundNo    string `json:"refund_no"`
}
type RefundQueryRes struct {
	Code       int    `json:"code"`
	TotalCount int    `json:"total_count"`
	Message    string `json:"message"`
	Refunds    []struct {
		ActualRefundAmount   string `json:"actual_refund_amount"`
		AdvanceStatus        string `json:"advance_status"`
		ApiOuterNo           string `json:"api_outer_no"`
		BadReason            string `json:"bad_reason"`
		BuyerNick            string `json:"buyer_nick"`
		ConsignMode          string `json:"consign_mode"`
		Created              string `json:"created"`
		CreatorName          string `json:"creator_name"`
		CsStatus             string `json:"cs_status"`
		CustomerId           string `json:"customer_id"`
		CustomerName         string `json:"customer_name"`
		CustomerNo           string `json:"customer_no"`
		DirectRefundAmount   string `json:"direct_refund_amount"`
		ErrorMsg             string `json:"error_msg"`
		ExchangeAmount       string `json:"exchange_amount"`
		FenxiaoNickName      string `json:"fenxiao_nick_name"`
		FenxiaoRefundNo      string `json:"fenxiao_refund_no"`
		FenxiaoTid           string `json:"fenxiao_tid"`
		FinishTime           string `json:"finish_time"`
		FlagName             string `json:"flag_name"`
		FromType             string `json:"from_type"`
		GoodsAmount          string `json:"goods_amount"`
		GuaranteRefundAmount string `json:"guarante_refund_amount"`
		GuaranteeMode        string `json:"guarantee_mode"`
		IsGoodsReceived      string `json:"is_goods_received"`
		IsTradeCharged       string `json:"is_trade_charged"`
		LogisticsName        string `json:"logistics_name"`
		LogisticsNo          string `json:"logistics_no"`
		LogisticsStyle       string `json:"logistics_style"`
		Modified             string `json:"modified"`
		OpConstraint         string `json:"op_constraint"`
		OtherAmount          string `json:"other_amount"`
		OuterNo              string `json:"outer_no"`
		Paid                 string `json:"paid"`
		PayAccount           string `json:"pay_account"`
		PayNo                string `json:"pay_no"`
		PlatformId           string `json:"platform_id"`
		PostAmount           string `json:"post_amount"`
		ProcessStatus        string `json:"process_status"`
		PushNo               string `json:"push_no"`
		ReasonId             string `json:"reason_id"`
		ReceiverAddress      string `json:"receiver_address"`
		ReceiverName         string `json:"receiver_name"`
		ReceiverTelno        string `json:"receiver_telno"`
		RefundAmount         string `json:"refund_amount"`
		RefundId             string `json:"refund_id"`
		RefundNo             string `json:"refund_no"`
		RefundOrderList      []struct {
			Barcode           string `json:"barcode"`
			BrandName         string `json:"brand_name"`
			CostPrice         string `json:"cost_price"`
			Created           string `json:"created"`
			Discount          string `json:"discount"`
			EditMask          string `json:"edit_mask"`
			FromMaskExt       string `json:"from_mask_ext"`
			GoodsId           string `json:"goods_id"`
			GoodsName         string `json:"goods_name"`
			GoodsNo           string `json:"goods_no"`
			IsSnEnable        string `json:"is_sn_enable"`
			MarketPrice       string `json:"market_price"`
			Modified          string `json:"modified"`
			Oid               string `json:"oid"`
			OrderId           string `json:"order_id"`
			OrderNum          string `json:"order_num"`
			OriginalPrice     string `json:"original_price"`
			Paid              string `json:"paid"`
			PlatformId        string `json:"platform_id"`
			PositionId        string `json:"position_id"`
			PositionNo        string `json:"position_no"`
			Price             string `json:"price"`
			ProcessStatus     string `json:"process_status"`
			RefundId          string `json:"refund_id"`
			RefundNum         string `json:"refund_num"`
			RefundOrderAmount string `json:"refund_order_amount"`
			Remark            string `json:"remark"`
			SalesOrderId      string `json:"sales_order_id"`
			SalesTid          string `json:"sales_tid"`
			SalesTradeId      string `json:"sales_trade_id"`
			SpecCode          string `json:"spec_code"`
			SpecId            string `json:"spec_id"`
			SpecName          string `json:"spec_name"`
			SpecNo            string `json:"spec_no"`
			SrcNo             string `json:"src_no"`
			StockinAmount     string `json:"stockin_amount"`
			StockinNum        string `json:"stockin_num"`
			SuiteId           string `json:"suite_id"`
			SuiteName         string `json:"suite_name"`
			SuiteNo           string `json:"suite_no"`
			SuiteNum          string `json:"suite_num"`
			Tag               string `json:"tag"`
			Tid               string `json:"tid"`
			TotalAmount       string `json:"total_amount"`
		} `json:"refund_order_list"`
		RefundOutGoodsList  []interface{} `json:"refund_out_goods_list"`
		RefundReason        string        `json:"refund_reason"`
		RefundTime          string        `json:"refund_time"`
		RefundVersion       string        `json:"refund_version"`
		Remark              string        `json:"remark"`
		ReturnAddress       string        `json:"return_address"`
		ReturnGoodsCount    string        `json:"return_goods_count"`
		ReturnLogisticsName string        `json:"return_logistics_name"`
		ReturnLogisticsNo   string        `json:"return_logistics_no"`
		ReturnMask          string        `json:"return_mask"`
		ReturnMobile        string        `json:"return_mobile"`
		ReturnName          string        `json:"return_name"`
		ReturnTelno         string        `json:"return_telno"`
		RevertReason        string        `json:"revert_reason"`
		RevertReasonInfo    string        `json:"revert_reason_info"`
		SalesTid            string        `json:"sales_tid"`
		SalesTradeId        string        `json:"sales_trade_id"`
		ShopId              string        `json:"shop_id"`
		ShopName            string        `json:"shop_name"`
		ShopNo              string        `json:"shop_no"`
		SrcNo               string        `json:"src_no"`
		Status              string        `json:"status"`
		StockinPreNo        string        `json:"stockin_pre_no"`
		SwapAddress         string        `json:"swap_address"`
		SwapArea            string        `json:"swap_area"`
		SwapCity            string        `json:"swap_city"`
		SwapDistrict        string        `json:"swap_district"`
		SwapLogisticsId     string        `json:"swap_logistics_id"`
		SwapLogisticsName   string        `json:"swap_logistics_name"`
		SwapLogisticsType   string        `json:"swap_logistics_type"`
		SwapMobile          string        `json:"swap_mobile"`
		SwapProvince        string        `json:"swap_province"`
		SwapReceiver        string        `json:"swap_receiver"`
		SwapTelno           string        `json:"swap_telno"`
		SwapTradeId         string        `json:"swap_trade_id"`
		SwapTradeNo         string        `json:"swap_trade_no"`
		SwapWarehouseId     string        `json:"swap_warehouse_id"`
		SwapWarehouseNo     string        `json:"swap_warehouse_no"`
		SwapZip             string        `json:"swap_zip"`
		Tid                 string        `json:"tid"`
		Type                string        `json:"type"`
		WarehouseId         string        `json:"warehouse_id"`
		WarehouseNo         string        `json:"warehouse_no"`
		WarehouseType       string        `json:"warehouse_type"`
		WmsOuterNo          string        `json:"wms_outer_no"`
		WmsResult           string        `json:"wms_result"`
		WmsStatus           string        `json:"wms_status"`
	} `json:"refunds"`
}

/*
*
查询退换管理
*/
func (s *WangDianTong) RefundQuery(ctx context.Context, req *RefundQueryReq) (res *RefundQueryRes, err error) {

	result, err := s.post(ctx, "/openapi2/refund_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type StockRefundLogisticsQueryReq struct {
	StartTime   string `json:"start_time"`
	EndTime     string `json:"end_time"`
	PageSize    string `json:"page_size"`
	PageNo      string `json:"page_no"`
	LogisticsNo string `json:"logistics_no"`
}

type StockRefundLogisticsQueryRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Trades  []struct {
		RecId            string `json:"rec_id"`
		ShopNo           string `json:"shop_no"`
		Tid              string `json:"tid"`
		LogisticsType    string `json:"logistics_type"`
		LogisticsNo      string `json:"logistics_no"`
		DeliveryTerm     string `json:"delivery_term"`
		ConsignTime      string `json:"consign_time"`
		Oids             string `json:"oids"`
		IsPartSync       string `json:"is_part_sync"`
		PlatformId       string `json:"platform_id"`
		TradeId          string `json:"trade_id"`
		LogisticsNameErp string `json:"logistics_name_erp"`
		LogisticsCodeErp string `json:"logistics_code_erp"`
		LogisticsName    string `json:"logistics_name"`
	} `json:"trades"`
}

/*
*
查询退货物流单号
*/
func (s *WangDianTong) StockRefundLogisticsQuery(ctx context.Context, req *StockRefundLogisticsQueryReq) (res *StockRefundLogisticsQueryRes, err error) {

	result, err := s.post(ctx, "/openapi2/stock_refund_logistics_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type StockinRefundPushReq struct {
	RefundNo      string               `json:"refund_no"`
	OuterNo       string               `json:"outer_no"`
	WarehouseNo   string               `json:"warehouse_no"`
	Remark        string               `json:"remark"`
	IsCheck       int                  `json:"is_check"`
	LogisticsNo   string               `json:"logistics_no"`
	LogisticsCode string               `json:"logistics_code"`
	DetailList    []*StockinDetailList `json:"detail_list"`
}

type StockinDetailList struct {
	SpecNo       string `json:"spec_no"`
	StockinNum   int    `json:"stockin_num"`
	BatchNo      string `json:"batch_no"`
	StockinPrice string `json:"stockin_price"`
}

type StockinRefundPushRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
}

/*
*
创建退货入库单
*/
func (s *WangDianTong) StockinRefundPush(ctx context.Context, req *StockinRefundPushReq) (res *StockinRefundPushRes, err error) {

	jsonStr := gjson.New(req)
	paramas := g.Map{
		"stockin_refund_info": jsonStr.MustToJsonString(),
	}
	result, err := s.post(ctx, "/openapi2/stockin_refund_push.php", paramas)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type StockinRefundQueryReq struct {
	StartTime   string `json:"start_time"`
	EndTime     string `json:"end_time"`
	PageSize    string `json:"page_size"`
	PageNo      string `json:"page_no"`
	ShopNo      string `json:"shop_no"`
	TimeType    string `json:"time_type"`
	SrcOrderNo  string `json:"src_order_no"`
	StockinNo   string `json:"stockin_no"`
	WarehouseNo string `json:"warehouse_no"`
}

type StockinRefundQueryRes struct {
	Code        int    `json:"code"`
	Message     string `json:"message"`
	TotalCount  int    `json:"total_count"`
	StockinList []struct {
		Status             string `json:"status"`
		StockinId          string `json:"stockin_id"`
		OrderNo            string `json:"order_no"`
		WarehouseNo        string `json:"warehouse_no"`
		WarehouseName      string `json:"warehouse_name"`
		StockinTime        string `json:"stockin_time"`
		CreatedTime        string `json:"created_time"`
		OrderType          string `json:"order_type"`
		GoodsAmount        string `json:"goods_amount"`
		TotalPrice         string `json:"total_price"`
		AdjustPrice        string `json:"adjust_price"`
		RightPrice         string `json:"right_price"`
		Discount           string `json:"discount"`
		TaxAmount          string `json:"tax_amount"`
		PostFee            string `json:"post_fee"`
		OtherFee           string `json:"other_fee"`
		Remark             string `json:"remark"`
		LogisticsType      string `json:"logistics_type"`
		CheckTime          string `json:"check_time"`
		SrcOrderNo         string `json:"src_order_no"`
		GoodsCount         string `json:"goods_count"`
		LogisticsName      string `json:"logistics_name"`
		LogisticsCode      string `json:"logistics_code"`
		LogisticsNo        string `json:"logistics_no"`
		ActualRefundAmount string `json:"actual_refund_amount"`
		RefundNo           string `json:"refund_no"`
		ProcessStatus      string `json:"process_status"`
		CustomerNo         string `json:"customer_no"`
		CustomerName       string `json:"customer_name"`
		NickName           string `json:"nick_name"`
		ShopName           string `json:"shop_name"`
		ShopNo             string `json:"shop_no"`
		ShopRemark         string `json:"shop_remark"`
		FlagName           string `json:"flag_name"`
		TradeNo            string `json:"trade_no"`
		TradeType          string `json:"trade_type"`
		StockinReason      string `json:"stockin_reason"`
		PlatformId         string `json:"platform_id"`
		OrderTypeName      string `json:"order_type_name"`
		DetailsList        []struct {
			StockinId        string `json:"stockin_id"`
			GoodsCount       string `json:"goods_count"`
			Discount         string `json:"discount"`
			CostPrice        string `json:"cost_price"`
			ProductionDate   string `json:"production_date"`
			ValidityDays     string `json:"validity_days"`
			ExpireDate       string `json:"expire_date"`
			SrcPrice         string `json:"src_price"`
			TaxPrice         string `json:"tax_price"`
			TaxAmount        string `json:"tax_amount"`
			Tax              string `json:"tax"`
			TotalCost        string `json:"total_cost"`
			Remark           string `json:"remark"`
			AdjustNum        string `json:"adjust_num"`
			AdjustPrice      string `json:"adjust_price"`
			RightNum         string `json:"right_num"`
			RightPrice       string `json:"right_price"`
			RightCost        string `json:"right_cost"`
			RecId            string `json:"rec_id"`
			SrcOrderDetailId string `json:"src_order_detail_id"`
			GoodsName        string `json:"goods_name"`
			GoodsNo          string `json:"goods_no"`
			SpecNo           string `json:"spec_no"`
			Prop2            string `json:"prop2"`
			SpecName         string `json:"spec_name"`
			SpecCode         string `json:"spec_code"`
			BrandNo          string `json:"brand_no"`
			BrandName        string `json:"brand_name"`
			GoodsUnit        string `json:"goods_unit"`
			BatchNo          string `json:"batch_no"`
		} `json:"details_list"`
	} `json:"stockin_list"`
}

/*
*查询出库单
 */
func (s *WangDianTong) StockinRefundQuery(ctx context.Context, req *StockinRefundQueryReq) (res *StockinRefundQueryRes, err error) {

	result, err := s.post(ctx, "/openapi2/stockin_order_query_refund.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
