package wangdiantong

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type GoodsListReq struct {
	SpecNo    string `json:"spec_no"`
	GoodsNo   string `json:"goods_no"`
	BrandNo   string `json:"brand_no"`
	ClassName string `json:"class_name"`
	Barcode   string `json:"barcode"`
	StartTime string `json:"start_time"`
	EndTime   string `json:"end_time"`
	PageSize  string `json:"page_size"`
	PageNo    string `json:"page_no"`
}

type GoodsListRes struct {
	Code       int    `json:"code"`
	Message    string `json:"message"`
	TotalCount string `json:"total_count"`
	GoodsList  []struct {
		GoodsId       string      `json:"goods_id"`
		GoodsNo       string      `json:"goods_no"`
		GoodsName     string      `json:"goods_name"`
		ShortName     string      `json:"short_name"`
		Alias         string      `json:"alias"`
		GoodsType     string      `json:"goods_type"`
		SpecCount     string      `json:"spec_count"`
		Pinyin        string      `json:"pinyin"`
		BrandNo       string      `json:"brand_no"`
		BrandName     string      `json:"brand_name"`
		Remark        string      `json:"remark"`
		Prop1         string      `json:"prop1"`
		Prop2         string      `json:"prop2"`
		Prop3         string      `json:"prop3"`
		Prop4         string      `json:"prop4"`
		Prop5         string      `json:"prop5"`
		Prop6         string      `json:"prop6"`
		Origin        string      `json:"origin"`
		ClassName     string      `json:"class_name"`
		ClassId       string      `json:"class_id"`
		UnitName      interface{} `json:"unit_name"`
		AuxUnitName   interface{} `json:"aux_unit_name"`
		FlagName      interface{} `json:"flag_name"`
		GoodsCreated  string      `json:"goods_created"`
		GoodsModified string      `json:"goods_modified"`
		SpecList      []struct {
			SpecId           string      `json:"spec_id"`
			GoodsId          string      `json:"goods_id"`
			SpecNo           string      `json:"spec_no"`
			SpecCode         string      `json:"spec_code"`
			Barcode          string      `json:"barcode"`
			SpecName         string      `json:"spec_name"`
			LowestPrice      string      `json:"lowest_price"`
			RetailPrice      string      `json:"retail_price"`
			WholesalePrice   string      `json:"wholesale_price"`
			MemberPrice      string      `json:"member_price"`
			MarketPrice      string      `json:"market_price"`
			CustomPrice1     string      `json:"custom_price1"`
			CustomPrice2     string      `json:"custom_price2"`
			SaleScore        string      `json:"sale_score"`
			PackScore        string      `json:"pack_score"`
			PickScore        string      `json:"pick_score"`
			ValidityDays     string      `json:"validity_days"`
			SalesDays        string      `json:"sales_days"`
			ReceiveDays      string      `json:"receive_days"`
			Weight           string      `json:"weight"`
			Length           string      `json:"length"`
			Width            string      `json:"width"`
			Height           string      `json:"height"`
			IsSnEnable       string      `json:"is_sn_enable"`
			IsAllowNegStock  string      `json:"is_allow_neg_stock"`
			IsNotNeedExamine string      `json:"is_not_need_examine"`
			IsZeroCost       string      `json:"is_zero_cost"`
			IsLowerCost      string      `json:"is_lower_cost"`
			IsNotUseAir      string      `json:"is_not_use_air"`
			TaxRate          string      `json:"tax_rate"`
			LargeType        string      `json:"large_type"`
			Remark           string      `json:"remark"`
			SpecCreated      string      `json:"spec_created"`
			SpecModified     string      `json:"spec_modified"`
			Prop1            string      `json:"prop1"`
			Prop2            string      `json:"prop2"`
			Prop3            string      `json:"prop3"`
			Prop4            string      `json:"prop4"`
			Prop5            string      `json:"prop5"`
			Prop6            string      `json:"prop6"`
			ImgUrl           string      `json:"img_url"`
			SpecAuxUnitName  interface{} `json:"spec_aux_unit_name"`
			SpecUnitName     interface{} `json:"spec_unit_name"`
			PlatSpecCount    int         `json:"plat_spec_count"`
		} `json:"spec_list"`
	} `json:"goods_list"`
}

/*
*

	商品列表
*/
func (s *WangDianTong) GoodsList(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {

	result, err := s.post(ctx, "/openapi2/goods_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsCreateReq struct {
	GoodsNo           string           `json:"goods_no"`             // 是 代表货品(spu)所有属性的唯一编号，用于系统货品区分，，SPU概念介绍,单击这里
	GoodsType         int              `json:"goods_type"`           // 货品类别 1销售商品 2原材料 3包装 4周转材料5虚拟商品6固定资产8虚拟代发货品0其它   不传默认为1
	GoodsName         string           `json:"goods_name"`           // 货品名称
	ShortName         string           `json:"short_name"`           // 货品简称
	Alias             string           `json:"alias"`                // 别名
	Pinyin            string           `json:"pinyin"`               // 拼音名称
	Origin            string           `json:"origin"`               // 产地
	ClassName         string           `json:"class_name"`           // 类别名称
	BrandName         string           `json:"brand_name"`           // 品牌名称
	UnitName          string           `json:"unit_name"`            // 基本单位
	Remark            string           `json:"remark"`               // 备注
	Props1            string           `json:"props1"`               // 自定义属性1
	Props2            string           `json:"props2"`               // 自定义属性2
	Props3            string           `json:"props3"`               // 自定义属性3
	Props4            string           `json:"props4"`               // 自定义属性4
	Props5            string           `json:"props5"`               // 自定义属性5
	Props6            string           `json:"props6"`               // 自定义属性6
	AuxUnitName       string           `json:"aux_unit_name"`        //  辅助单位名称
	FlagName          string           `json:"flag_name"`            // 标记名称
	AddToWarehouseNos []string         `json:"add_to_warehouse_nos"` //把货品数据添加到对应仓库中   请求示例 ["warehouse_01", "warehouse_02"]
	SpecList          []*GoodsSpecList `json:"spec_list"`            //请求参数的2级数据节点，包含sku所有属性信息的数据节点,节点下数据字段详见下述"spec_list"
}

type GoodsSpecList struct {
	SpecNo          string  `json:"spec_no"`            //	代表单品(sku)所有属性的唯一编码，用于系统单品区分，SKU概念介绍单击这里
	SpecCode        string  `json:"spec_code"`          //规格编码
	Barcode         string  `json:"barcode"`            //主条码
	SpecName        string  `json:"spec_name"`          //规格名称
	LowestPrice     float64 `json:"lowest_price"`       //	最低价
	ImgUrl          string  `json:"img_url"`            //	图片url地址
	RetailPrice     float64 `json:"retail_price"`       //商品标价，系统内手工建单时使用，传值时需谨慎
	WholesalePrice  float64 `json:"wholesale_price"`    //	批发价
	MemberPrice     float64 `json:"member_price"`       //	会员价
	MarketPrice     float64 `json:"market_price"`       //	市场价
	SaleScore       float64 `json:"sale_score"`         //	销售积分
	PackScore       float64 `json:"pack_score"`         //	打包积分
	PickScore       float64 `json:"pick_score"`         //	拣货积分
	ValidityDays    float64 `json:"validity_days"`      //	保质期，天数（不能超过32767天）
	Weight          float64 `json:"weight"`             //重量
	TaxRate         float64 `json:"tax_rate"`           //税率
	SpecAuxUnitName string  `json:"spec_aux_unit_name"` //单品辅助单位名称
	TaxCode         string  `json:"tax_code"`           //	税务编码
	SpecRemark      string  `json:"spec_remark"`        //		备注
}

type GoodsCreateRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
}

/*
*创建平台货品
 */
func (s *WangDianTong) GoodsPush(ctx context.Context, req []*GoodsCreateReq) (res *GoodsCreateRes, err error) {

	body, err := json.Marshal(req)
	if nil != err {
		return
	}
	params := g.Map{}
	params["goods_list"] = gconv.String(body)
	result, err := s.post(ctx, "/openapi2/goods_push.php", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
