package tmv3

import (
	"context"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type OrderDetailReq struct {
	OrderId string //订单 id
}

type OrderDetailRes struct {
	CreateDate      string `json:"createDate"`
	DistributorId   string `json:"distributorId"`
	LogisticsStatus string `json:"logisticsStatus"`
	OrderId         string `json:"orderId"`
	OrderAmount     string `json:"orderAmount"`
	OrderStatus     string `json:"orderStatus"`
	OrderLineList   []struct {
		ProductPic   string `json:"productPic"`
		ProductPrice []struct {
			FundAmountMoney string `json:"fundAmountMoney"`
		} `json:"productPrice"`
		ProductTitle    string `json:"productTitle"`
		ProductId       string `json:"productId"`
		Number          string `json:"number"`
		OrderLineStatus string `json:"orderLineStatus"`
		LogisticsStatus string `json:"logisticsStatus"`
		SkuId           string `json:"skuId"`
		SkuTitle        string `json:"skuTitle"`
		OrderLineId     string `json:"orderLineId"`
		OrderId         string `json:"orderId"`
	} `json:"orderLineList"`
}

// Detail 获取订单详情
func (s orderTm) Detail(ctx context.Context, req OrderDetailReq) (res *OrderDetailRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "GetOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	r, err := server.GetOrder(tea.String(req.OrderId))
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
