package tm

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type logisticsTm struct {
}

var Logistics = logisticsTm{}

type LogisticsTraceRes struct {
	Code      string `json:"Code"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
	Data      struct {
		Data []struct {
			DataProvider         string `json:"DataProvider"`
			LogisticsCompanyName string `json:"LogisticsCompanyName"` //物流公司名称
			MailNo               string `json:"MailNo"`               //运单号
			LogisticsCompanyCode string `json:"LogisticsCompanyCode"` //物流公司Code
			LogisticsDetailList  struct {
				LogisticsDetailList []struct {
					StanderdDesc string `json:"StanderdDesc"`
					OcurrTimeStr string `json:"OcurrTimeStr"`
				} `json:"LogisticsDetailList"`
			} `json:"LogisticsDetailList"`
			DataProviderTitle string `json:"DataProviderTitle"`
		} `json:"Data"`
	} `json:"Data"`
}

//Trace 物流查询接口
func (s *logisticsTm) Trace(ctx context.Context, UserId, LmOrderId string) (res *LogisticsTraceRes, err error) {

	method := "queryLogistics"

	request := map[string]string{
		"BizUid":           server.BizUid,
		"LmOrderId":        LmOrderId,
		"AccountType":      "ANONY",
		"ThirdPartyUserId": UserId,
	}

	result, err := post(ctx, method, request)
	err = gjson.New(result).Scan(&res)
	return
}
