package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type orderRefund struct {
}

var OrderRefund = orderRefund{}

type OrderRefundReq struct {
	ThirdUserId          string   `json:"thirdUserId"`
	OrderNo              string   `json:"orderNo"`
	AfterSaleApplyAmount string   `json:"afterSaleApplyAmount"`
	IsReceived           string   `json:"isReceived"`
	ReturnName           string   `json:"returnName"`
	CityId               string   `json:"cityId"`
	AfterSaleReason      string   `json:"afterSaleReason"`
	ProvinceId           string   `json:"provinceId"`
	AsType               string   `json:"asType"`
	ReturnPhone          string   `json:"returnPhone"`
	Spec                 string   `json:"spec"`
	ReturnAddress        string   `json:"returnAddress"`
	DistrictId           string   `json:"districtId"`
	ProofImageUrls       []string `json:"proofImageUrls"`
	ApplyRemark          string   `json:"applyRemark"`
	SkuOrderNo           string   `json:"skuOrderNo"`
	AfterSaleApplyCount  string   `json:"afterSaleApplyCount"`
	ExSkuId              string   `json:"exSkuId"`
	AsReason             string   `json:"asReason"`
}

type OrderRefundRes struct {
}

func (s *orderRefund) Apply(ctx context.Context, req *OrderRefundReq) (res *OrderRefundRes, err error) {
	method := "mengxiang.aftersale.apply.order"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type OrefundRefundCancelReq struct {
	ThirdUserId  string `json:"thirdUserId"`
	AfterSalesNo string `json:"afterSalesNo"`
}

type OrefundRefundCancelRes struct {
}

func (s *orderRefund) Cancel(ctx context.Context, req *OrefundRefundCancelReq) (res *OrefundRefundCancelRes, err error) {
	method := "mengxiang.aftersale.cancel.order"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type OrefundRefundDetailReq struct {
	ThirdUserId  string `json:"thirdUserId"`
	AfterSalesNo string `json:"afterSalesNo"`
}

type OrefundRefundDetailRes struct {
}

func (s *orderRefund) Detail(ctx context.Context, req *OrefundRefundDetailReq) (res *OrefundRefundDetailRes, err error) {
	method := "mengxiang.aftersale.order.detail"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderfundRefundDetailReq struct {
	OrderNo     string `json:"orderNo"`
	SkuOrderNo  string `json:"skuOrderNo"`
	ThirdUserId string `json:"thirdUserId"`
}

type OrderfundRefundDetailRes struct {
}

func (s *orderRefund) Check(ctx context.Context, req *OrderfundRefundDetailReq) (res *OrderfundRefundDetailRes, err error) {
	method := "mengxiang.aftersale.order.support.exchange"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
