package dwd

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

//订单
type orderDwd struct {
}

var Order = &orderDwd{}

type OrderCreateReq struct {
	OrderSn   string            `json:"out_order_id"`    //外部关联主订单号
	Consignee string            `json:"consignee_name"`  //收件人
	Phone     string            `json:"consignee_phone"` //收件人电话
	Province  string            `json:"province"`        //省份
	City      string            `json:"city"`            //城市
	District  string            `json:"district"`        //区县
	Address   string            `json:"address"`         //详细地址
	List      []OrderCreateItem `json:"sub_orders"`      //子订单
}

type OrderCreateItem struct {
	SkuID  int    `json:"sku_id"`   //sku_id
	Amount int    `json:"amount"`   //数量
	Remark string `json:"user_mem"` //订单备注
}

type OrderCreateRes struct {
	Errno     int              `json:"errno"`
	Errmsg    string           `json:"errmsg"`
	Data      *OrderCreateData `json:"data"`
	RequestId string           `json:"request_id"`
	Timestamp int              `json:"timestamp"`
	Signature string           `json:"signature"`
}

type OrderCreateData struct {
	BatchNo        string `json:"batch_no"`
	OutOrderId     string `json:"out_order_id"`
	TotalPrice     int    `json:"total_price"`
	PayPrice       int    `json:"pay_price"`
	ConsigneeName  string `json:"consignee_name"`
	ConsigneePhone string `json:"consignee_phone"`
	Province       string `json:"province"`
	City           string `json:"city"`
	District       string `json:"district"`
	Address        string `json:"address"`
	DeliveryPrice  int    `json:"delivery_price"`
	Orders         []struct {
		OrderId       int64  `json:"order_id"`
		TotalPrice    int    `json:"total_price"`
		PayPrice      int    `json:"pay_price"`
		Amount        int    `json:"amount"`
		DeliveryPrice int    `json:"delivery_price"`
		UserMem       string `json:"user_mem"`
		SubOrders     []struct {
			SubOrderId int    `json:"sub_order_id"`
			SkuId      int    `json:"sku_id"`
			SkuName    string `json:"sku_name"`
			UnitPrice  int    `json:"unit_price"`
			Amount     int    `json:"amount"`
			TotalPrice int    `json:"total_price"`
			PayPrice   int    `json:"pay_price"`
			ProductId  int    `json:"product_id"`
			Thumbnail  string `json:"thumbnail"`
		} `json:"sub_orders"`
	} `json:"orders"`
}

//Create  下单
func (*orderDwd) Create(ctx context.Context, req OrderCreateReq) (res *OrderCreateRes, err error) {
	var method = "order.create"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &OrderCreateRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type OrderCommonReq struct {
	BatchNo string `json:"batch_no"`
	OrderSn string `json:"out_order_id,omitempty"`
}
type OrderPayRes struct {
	Errno     int           `json:"errno"`
	Errmsg    string        `json:"errmsg"`
	Data      *OrderPayData `json:"data"`
	RequestId string        `json:"request_id"`
	Timestamp int           `json:"timestamp"`
	Signature string        `json:"signature"`
}

type OrderPayData struct {
	Res string `json:"res"`
}

//Pay  下单
func (*orderDwd) Pay(ctx context.Context, req OrderCommonReq) (res *OrderPayRes, err error) {
	var method = "order.pay"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &OrderPayRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type OrderCancelReq struct {
	BatchNo string `json:"batch_no"`
	OrderSn string `json:"out_order_id,omitempty"`
}

type OrderCancelRes struct {
	Errno     int              `json:"errno"`
	Errmsg    string           `json:"errmsg"`
	Data      *OrderCancelData `json:"data"`
	RequestId string           `json:"request_id"`
	Timestamp int              `json:"timestamp"`
	Signature string           `json:"signature"`
}

type OrderCancelData struct {
	Res string `json:"res"`
}

//Cancel  取消（未支付订单）
func (*orderDwd) Cancel(ctx context.Context, req OrderCommonReq) (res *OrderCancelRes, err error) {
	var method = "order.cancel"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &OrderCancelRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}

type OrderDetailRes struct {
	Errno     int              `json:"errno"`
	Errmsg    string           `json:"errmsg"`
	Data      *OrderDetailData `json:"data"`
	RequestId string           `json:"request_id"`
	Timestamp int              `json:"timestamp"`
	Signature string           `json:"signature"`
}

type OrderDetailData struct {
	OutOrderId     int    `json:"out_order_id "`
	BatchNo        string `json:"batch_no"`
	TotalPrice     int    `json:"total_price"`
	PayPrice       int    `json:"pay_price"`
	ConsigneeName  string `json:"consignee_name"`
	ConsigneePhone string `json:"consignee_phone"`
	Province       string `json:"province"`
	City           string `json:"city"`
	District       string `json:"district"`
	Address        string `json:"address"`
	DeliveryPrice  int    `json:"delivery_price"`
	UserMem        string `json:"user_mem"`
	Orders         []struct {
		OrderId    int64 `json:"order_id"`
		TotalPrice int   `json:"total_price"`
		PayPrice   int   `json:"pay_price"`
		Amount     int   `json:"amount"`
		Status     int   `json:"status"`
		//订单状态 1.未支付 2.已支付.3.已完成 4.已取消 5. 申请退款 6.退款中 7. 已退款
		// 8.拒绝退款 9.拼团支付成功 10.审核中 11.等待开奖 12.申请退货 13.待退货 14.退货中 15.拒绝退货 16.已退货 17已退货退款中
		//18 已退货退款 19.已退货拒绝退款
		DeliveryPrice  int    `json:"delivery_price"`
		DeliveryStatus int    `json:"delivery_status"` //配送状态：1.未发货 2.已发货 3.配送完成
		DeliveryNo     string `json:"delivery_no"`
		DeliveryCode   string `json:"delivery_code"`
		DeliveryTime   int    `json:"delivery_time"`
		ConfirmTime    int    `json:"confirm_time"`
		UserMem        string `json:"user_mem"`
		CreatedAt      int    `json:"created_at"`
		SubOrders      []struct {
			SubOrderId    int    `json:"sub_order_id"`
			SkuId         int    `json:"sku_id"`
			SkuName       string `json:"sku_name"`
			UnitPrice     int    `json:"unit_price"`
			Amount        int    `json:"amount"`
			TotalPrice    int    `json:"total_price"`
			PayPrice      int    `json:"pay_price"`
			ProductId     int    `json:"product_id"`
			Thumbnail     string `json:"thumbnail"`
			SaleAttribute []struct {
				AttributeName  string `json:"attribute_name"`
				AttributeValue string `json:"attribute_value"`
			} `json:"sale_attribute"`
		} `json:"sub_orders"`
	} `json:"orders"`
}

//Detail  详情
func (*orderDwd) Detail(ctx context.Context, req OrderCommonReq) (res *OrderDetailRes, err error) {
	var method = "order.detail"
	result, err := post(ctx, method, req)
	if err != nil {
		return
	}
	res = &OrderDetailRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}
