package yz

import (
	"bytes"
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
	"io"
	"io/ioutil"
	"mime/multipart"
	"net/http"
	"os"
	"time"
)

type Config struct {
	ApiUrl      string
	GetTokenUrl string
	AppKey      string
	AppSecret   string
	GrantId     string
}

type CommonRes struct {

	Success       bool   `json:"success"`
	Code    int `json:"code"`
	Message string `json:"message"`
	TraceId string `json:"trace_id"`
}

type client struct {
	*Config
	AccessToken string
}

var server *client

const CacheKey = "yz:token"
const pkgName = "yz"
const authorizeType = "silent"

func New(config *Config) {
	_ = gconv.Scan(config, &server)
	return
}

// post 请求
func (s *client) post(ctx context.Context, method string, params g.Map) (str string, err error) {
	Start := gtime.TimestampMilli()
	Request := g.Client()
	Request.SetHeader("Content-Type", "application/json")
	url := method + "?access_token=" + server.AccessToken
	resp, err := Request.Timeout(time.Second*5).Post(url, params)
	defer func() {
		_ = resp.Close()
		paramStr := gjson.New(params).MustToJsonString()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", url)
		if err != nil {
			g.Log().Ctx(ctx).Cat(pkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v ms】", paramStr, err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v ms】", paramStr, str, gtime.TimestampMilli()-Start)
		}
	}()
	if err != nil {
		return
	}
	str = resp.ReadAllString()
	return
}

// post 请求
func (s *client) postImg(ctx context.Context, method string, params string) (str string, err error) {
	Start := gtime.TimestampMilli()
	url := method + "?access_token=" + server.AccessToken
	client := http.Client{}
	bodyBuf := &bytes.Buffer{}
	bodyWrite := multipart.NewWriter(bodyBuf)

	file, err := os.Open(params)

	defer file.Close()
	if err != nil {
		return
	}


	fileWrite, err := bodyWrite.CreateFormFile("image", params)
	_, err = io.Copy(fileWrite, file)

	if err != nil {
		return

	}
	bodyWrite.Close() //要关闭，会将w.w.boundary刷写到w.writer中
	// 创建请求
	contentType := bodyWrite.FormDataContentType()
	req, err := http.NewRequest(http.MethodPost, url, bodyBuf)
	if err != nil {

		return
	}
	// 设置头
	req.Header.Set("Content-Type", contentType)
	resp, err := client.Do(req)
	if err != nil {
		return
	}
	if resp==nil{
		return
	}

	defer func() {
		_ = resp.Body.Close()
		paramStr := gjson.New(params).MustToJsonString()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", url)
		_ = os.Remove(params)
		if err != nil {
			g.Log().Ctx(ctx).Cat(pkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v ms】", paramStr, err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v ms】", paramStr, str, gtime.TimestampMilli()-Start)
		}
	}()
	b, err := ioutil.ReadAll(resp.Body)
	if err != nil {
		return
	}

	str = string(b)
	return
}

// requestApi 请求
func (s *client) requestApi(ctx context.Context, method string, businessParams g.Map) (str string, err error) {
	params, err := s.createPostRequest(ctx, businessParams)
	if err != nil {
		return
	}
	urlMethod := s.ApiUrl + method
	str, err = s.post(ctx, urlMethod, params)
	return
}

// requestApi 请求
func (s *client) requestApiImg(ctx context.Context, method string, businessParams string) (str string, err error) {
	_, err = s.createPostRequest(ctx, nil)
	if err != nil {
		return
	}
	urlMethod := s.ApiUrl + method
	str, err = s.postImg(ctx, urlMethod, businessParams)
	return
}
func (s *client) createPostRequest(ctx context.Context, businessParams g.Map) (res g.Map, err error) {
	err = s.getAccessToken(ctx)
	if err != nil {
		return
	}
	res = g.Map{
		"token": s.AccessToken,
	}
	if businessParams != nil {
		for k, v := range businessParams {
			res[k] = v
		}
	}
	return
}
