package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type addressTm struct {
}

var Address = addressTm{}

type AddressListReq struct {
	DivisionCode string `json:"divisionCode"`
}

type AddressListRes struct {
	RequestId    string             `json:"requestId"`
	DivisionList []*AddressListItem `json:"divisionList"`
}

type AddressListItem struct {
	ParentId      int    `json:"parentId"`
	DivisionCode  int    `json:"divisionCode"`
	DivisionName  string `json:"divisionName"`
	DivisionLevel int    `json:"divisionLevel"`
	Pinyin        string `json:"pinyin"`
}

func (s addressTm) List(ctx context.Context, req AddressListReq) (res *AddressListRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "QueryChildDivisionCode")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	Request := &client.QueryChildDivisionCodeRequest{}
	var Body = new(client.DivisionQuery)
	if req.DivisionCode != "" {
		Body.SetDivisionCode(req.DivisionCode)
	}

	Request.SetBody(Body)

	r, err := server.QueryChildDivisionCode(Request)
	if err != nil {
		return
	}
	//
	err = gjson.New(r.Body).Scan(&res)
	return
}
