package suning

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type OrderLogistReq struct {
	SnRequest struct {
		SnBody struct {
			GetOrderlogist struct {
				OrderItemId string `json:"orderItemId"`
			} `json:"getOrderlogist"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderLogistRes struct {
	SnResponseContent struct {
		SnBody struct {
			GetOrderlogist struct {
				LogisticNumber    string `json:"logisticNumber"`
				OrderItemId       string `json:"orderItemId"`
				ExpressCompany    string `json:"expressCompany"`
				LogisticsInfoList []struct {
					OperateState string `json:"operateState"`
					OperateTime  string `json:"operateTime"`
					Operator     string `json:"operator"`
				} `json:"logisticsInfoList"`
			} `json:"getOrderlogist"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取订单物流详情
func GetOrderLogist(ctx context.Context, OrderItemId string) (res OrderLogistRes, err error) {
	params := OrderLogistReq{}
	params.SnRequest.SnBody.GetOrderlogist.OrderItemId = OrderItemId
	result, err := post(ctx, "suning.sngoods.orderlogist.get", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderConfirmReceiptReq struct {
	SnRequest struct {
		SnBody struct {
			QueryConfirmreceipt struct {
				SkuConfirmList []*OrderConfirmSkuConfirmList `json:"skuConfirmList"`
				OrderId        string                        `json:"orderId"`
			} `json:"queryConfirmreceipt"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderConfirmSkuConfirmList struct {
	OrderItemId string `json:"orderItemId"`
	SkuId       string `json:"skuId"`
}

type OrderConfirmReceiptRes struct {
	SnResponseContent struct {
		SnBody struct {
			QueryConfirmreceipt struct {
				ResultList []struct {
					OrderItemId  string `json:"orderItemId"`
					ApiIsSuccess string `json:"apiIsSuccess"`
				} `json:"resultList"`
			} `json:"queryConfirmreceipt"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 确认收货
func OrderConfirmReceipt(ctx context.Context, OrderId string, SkuConfirmList []*OrderConfirmSkuConfirmList) (res OrderConfirmReceiptRes, err error) {
	params := OrderConfirmReceiptReq{}
	params.SnRequest.SnBody.QueryConfirmreceipt.OrderId = OrderId
	params.SnRequest.SnBody.QueryConfirmreceipt.SkuConfirmList = SkuConfirmList
	result, err := post(ctx, "suning.sngoods.confirmreceipt.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
