package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type user struct {
}

var User = user{}

type UserInfoReq struct {
	ThirdUserId string `json:"thirdUserId"`
	Mobile      string `json:"mobile"`
	Name        string `json:"name"`
}

type UserAddRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    bool   `json:"data"`
}

func (s *user) Add(ctx context.Context, req *UserInfoReq) (res *UserAddRes, err error) {
	method := "mengxiang.supply.user.create"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type UserDetailReq struct {
	ThirdUserId string `json:"thirdUserId"`
}

type UserInfoRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		ThirdUserId string `json:"thirdUserId"`
		Name        string `json:"name"`
	} `json:"data"`
}

func (s *user) Detail(ctx context.Context, req *UserDetailReq) (res *UserInfoRes, err error) {
	method := "mengxiang.supply.user.detail"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
