package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type goods struct {
}

var Goods = goods{}

type GoodsListReq struct {
	PageIndex string `json:"pageIndex"`
	PageSize  string `json:"pageSize"`
}

type GoodsListRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		GoodsList []struct {
			ActivityId             string   `json:"activityId"`
			ActivitySpuId          string   `json:"activitySpuId"`
			ProductNum             string   `json:"productNum"`
			StartTime              string   `json:"startTime"`
			EndTime                string   `json:"endTime"`
			SpuId                  string   `json:"spuId"`
			SpuType                string   `json:"spuType"`
			SpuName                string   `json:"spuName"`
			SpuImage               []string `json:"spuImage"`
			Status                 int      `json:"status"`
			SoldOut                bool     `json:"soldOut"`
			CategoryCode           string   `json:"categoryCode"`
			CategoryName           string   `json:"categoryName"`
			SecondCategoryCode     string   `json:"secondCategoryCode"`
			SecondCategoryName     string   `json:"secondCategoryName"`
			FirstCategoryCode      string   `json:"firstCategoryCode"`
			FirstCategoryName      string   `json:"firstCategoryName"`
			BrandId                string   `json:"brandId"`
			BrandName              string   `json:"brandName"`
			BrandLogo              string   `json:"brandLogo"`
			SpuDetailImage         []string `json:"spuDetailImage"`
			SizeImage              string   `json:"sizeImage,omitempty"`
			SalesAttributeInfoList []struct {
				AttributeCode  string   `json:"attributeCode"`
				AttributeName  string   `json:"attributeName"`
				AttributeValue string   `json:"attributeValue"`
				Priority       int      `json:"priority"`
				AttributeImage []string `json:"attributeImage"`
			} `json:"salesAttributeInfoList"`
			BaseAttributeInfoList []struct {
				AttributeCode  string `json:"attributeCode"`
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"baseAttributeInfoList"`
			SkuList []struct {
				SkuId                  string `json:"skuId"`
				SoldOut                bool   `json:"soldOut"`
				SalesAttributeInfoList []struct {
					AttributeName  string `json:"attributeName"`
					AttributeValue string `json:"attributeValue"`
					Priority       int    `json:"priority"`
				} `json:"salesAttributeInfoList"`
				BaseAttributeInfoList []struct {
					AttributeCode  string `json:"attributeCode"`
					AttributeName  string `json:"attributeName"`
					AttributeValue string `json:"attributeValue"`
				} `json:"baseAttributeInfoList"`
				CurrentPriceInfo struct {
					ActivitySpuId           string  `json:"activitySpuId"`
					MarketingPrice          int     `json:"marketingPrice"`
					Commission              float64 `json:"commission"`
					CommissionAddition      int     `json:"commissionAddition"`
					SupplyPrice             float64 `json:"supplyPrice"`
					TagPrice                int     `json:"tagPrice"`
					SowingPrice             int     `json:"sowingPrice"`
					PromotionDetailInfoList []struct {
						PromotionId   string  `json:"promotionId"`
						PromotionType string  `json:"promotionType"`
						StartTime     string  `json:"startTime"`
						EndTime       string  `json:"endTime"`
						PromoPrice    int     `json:"promoPrice"`
						SupplyPrice   float64 `json:"supplyPrice"`
					} `json:"promotionDetailInfoList,omitempty"`
				} `json:"currentPriceInfo"`
				AdvancePriceInfo struct {
				} `json:"advancePriceInfo"`
			} `json:"skuList"`
		} `json:"goodsList"`
	} `json:"data"`
}

//List 列表
func (s *goods) List(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {
	method := "mengxiang.supply.consignment.goods.search"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailReq struct {
	ThirdUserId string `json:"thirdUserId"`
	SpuId       string `json:"spuId"`
}

type GoodsDetailRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		ActivityId             string   `json:"activityId"`
		ActivitySpuId          string   `json:"activitySpuId"`
		ProductNum             string   `json:"productNum"`
		StartTime              string   `json:"startTime"`
		EndTime                string   `json:"endTime"`
		SpuId                  string   `json:"spuId"`
		SpuType                string   `json:"spuType"`
		SpuName                string   `json:"spuName"`
		SpuImage               []string `json:"spuImage"`
		Status                 int      `json:"status"`
		SoldOut                bool     `json:"soldOut"`
		CategoryCode           string   `json:"categoryCode"`
		CategoryName           string   `json:"categoryName"`
		SecondCategoryCode     string   `json:"secondCategoryCode"`
		SecondCategoryName     string   `json:"secondCategoryName"`
		FirstCategoryCode      string   `json:"firstCategoryCode"`
		FirstCategoryName      string   `json:"firstCategoryName"`
		BrandId                string   `json:"brandId"`
		BrandName              string   `json:"brandName"`
		BrandLogo              string   `json:"brandLogo"`
		SpuDetailImage         []string `json:"spuDetailImage"`
		SizeImage              string   `json:"sizeImage"`
		SalesAttributeInfoList []struct {
			AttributeCode  string   `json:"attributeCode"`
			AttributeName  string   `json:"attributeName"`
			AttributeValue string   `json:"attributeValue"`
			Priority       int      `json:"priority"`
			AttributeImage []string `json:"attributeImage"`
		} `json:"salesAttributeInfoList"`
		BaseAttributeInfoList []struct {
			AttributeCode  string `json:"attributeCode"`
			AttributeName  string `json:"attributeName"`
			AttributeValue string `json:"attributeValue"`
		} `json:"baseAttributeInfoList"`
		SkuList []struct {
			SkuId                  string `json:"skuId"`
			SoldOut                bool   `json:"soldOut"`
			SalesAttributeInfoList []struct {
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
				Priority       int    `json:"priority"`
			} `json:"salesAttributeInfoList"`
			BaseAttributeInfoList []struct {
				AttributeCode  string `json:"attributeCode"`
				AttributeName  string `json:"attributeName"`
				AttributeValue string `json:"attributeValue"`
			} `json:"baseAttributeInfoList"`
			CurrentPriceInfo struct {
				ActivitySpuId      string `json:"activitySpuId"`
				MarketingPrice     int    `json:"marketingPrice"`
				Commission         int    `json:"commission"`
				CommissionAddition int    `json:"commissionAddition"`
				SupplyPrice        int    `json:"supplyPrice"`
				TagPrice           int    `json:"tagPrice"`
				SowingPrice        int    `json:"sowingPrice"`
			} `json:"currentPriceInfo"`
			AdvancePriceInfo struct {
			} `json:"advancePriceInfo"`
		} `json:"skuList"`
	} `json:"data"`
}

//List  商品列表
func (s *goods) Detail(ctx context.Context, req *GoodsDetailReq) (res *GoodsDetailRes, err error) {
	method := "mengxiang.supply.consignment.goods.detail"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
