package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type activityIkc struct {
}

//Activity 活动
var Activity = activityIkc{}

type ActivityListReq struct {
	ActiveModel int      `json:"activeModel,omitempty"`
	CategoryId  string   `json:"categoryId,omitempty"`
	ActiveIds   []string `json:"activeIds,omitempty"`
	PageNo      int      `json:"pageNo"`
	PageSize    int      `json:"pageSize"`
}

type ActivityListRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Total         int    `json:"total"`
	Data          []struct {
		Activity struct {
			Id                    string   `json:"id"`
			StartDate             string   `json:"startDate"`
			EndDate               string   `json:"endDate"`
			Name                  string   `json:"name"`
			Description           string   `json:"description"`
			Banner                []string `json:"banner"`
			Brand                 string   `json:"brand"`
			BrandLogoUrl          string   `json:"brandLogoUrl"`
			StatementByDay        string   `json:"statementByDay"`
			CategoryId            string   `json:"categoryId"`
			Category              string   `json:"category"`
			DeliverTime           string   `json:"deliverTime"`
			Content               string   `json:"content"`
			ActiveModel           int      `json:"activeModel"`
			AftersaleEndTime      string   `json:"aftersaleEndTime"`
			PreviewInformation    string   `json:"previewInformation"`
			RefundInsurance       bool     `json:"refundInsurance"`
			IsExchangeRefundGoods int      `json:"isExchangeRefundGoods"`
			ActiveType            int      `json:"activeType"`
			Status                int      `json:"status"`
		} `json:"activity"`
	} `json:"data"`
}

//List 列表
func (*activityIkc) List(ctx context.Context, req ActivityListReq) (res *ActivityListRes, err error) {
	method := "activity/v2/list/filter"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type ActivityDetailRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		Activity struct {
			Id                    string   `json:"id"`
			StartDate             string   `json:"startDate"`
			EndDate               string   `json:"endDate"`
			Name                  string   `json:"name"`
			Description           string   `json:"description"`
			Banner                []string `json:"banner"`
			Brand                 string   `json:"brand"`
			BrandLogoUrl          string   `json:"brandLogoUrl"`
			StatementByDay        string   `json:"statementByDay"`
			CategoryId            string   `json:"categoryId"`
			Category              string   `json:"category"`
			DeliverTime           string   `json:"deliverTime"`
			Content               string   `json:"content"`
			ActiveModel           int      `json:"activeModel"`
			AftersaleEndTime      string   `json:"aftersaleEndTime"`
			PreviewInformation    string   `json:"previewInformation"`
			RefundInsurance       bool     `json:"refundInsurance"`
			IsExchangeRefundGoods int      `json:"isExchangeRefundGoods"`
			ActiveType            int      `json:"activeType"`
			WaterMarkLicense      string   `json:"waterMarkLicense"`
			IsSuppotVatInvoice    int      `json:"isSuppotVatInvoice"`
			Status                int      `json:"status"`
		} `json:"activity"`
	} `json:"data"`
}

//Detail 详情
func (*activityIkc) Detail(ctx context.Context, req string) (res *ActivityDetailRes, err error) {
	method := "activity/detail"
	result, err := post(ctx, method, g.Map{
		"liveId": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
