package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type refundGome struct {
}

var Refund = refundGome{}

type ReturnCountReq struct {
	DeliveryId   string `json:"deliveryId"`
	OuterOrderId string `json:"outerOrderId"`
	SkuItemId    string `json:"skuItemId"`
	MchSkuId     string `json:"mchSkuId"`
}

type ReturnCountRes struct {
	*CommonRes
	Data struct {
		ReturnableQuantity int `json:"returnableQuantity"`
	} `json:"data"`
}
type ServiceTypeReq struct {
	DeliveryId   string `json:"deliveryId"`
	AddrCode     string `json:"addrCode"`
	SkuItemId    string `json:"skuItemId"`
	MchSkuId     string `json:"mchSkuId"`
	OuterOrderId string `json:"outerOrderId"`
}

type ServiceTypeRes struct {
	*CommonRes
	Data struct {
		AfterServiceTypes []struct {
			Code int    `json:"code"`
			Name string `json:"name"`
		} `json:"afterServiceTypes"`
		ReturnWareTypes []struct {
			Code int    `json:"code"`
			Name string `json:"name"`
		} `json:"returnWareTypes"`
	} `json:"data"`
}

type RefundCreateReq struct {
	AfterServiceType     string `json:"afterServiceType"`
	OuterAfterServiceId  string `json:"outerAfterServiceId"`
	SubmitTime           string `json:"submitTime"`
	OriginalOuterOrderId string `json:"originalOuterOrderId"`
	OuterOrderId         string `json:"outerOrderId"`
	OriginalDeliveryId   string `json:"originalDeliveryId"`
	ReturnType           string `json:"returnType"`
	ReturnWareType       string `json:"returnWareType"`
	RefundAmount         string `json:"refundAmount"`
	PickWareInfo         string `json:"pickWareInfo"`
	PickWareTime         string `json:"pickWareTime"`
	Name                 string `json:"name"`
	Phone                string `json:"phone"`
	Address              string `json:"address"`
	AddressCode          string `json:"addressCode"`
	AddressDetail        string `json:"addressDetail"`
	Address1             string `json:"address1"`
	Address2             string `json:"address2"`
	Address3             string `json:"address3"`
	Address4             string `json:"address4"`
	SkuItems             struct {
		OuterSkuItemId    string `json:"outerSkuItemId"`
		OriginalSkuItemId string `json:"originalSkuItemId"`
		MchSkuId          string `json:"mchSkuId"`
		SkuQuantity       string `json:"skuQuantity"`
		SkuName           string `json:"skuName"`
		DealPrice         string `json:"dealPrice"`
	} `json:"skuItems"`
	AfterSaleImages struct {
		ImageInx  string `json:"imageInx"`
		ImageType string `json:"imageType"`
		ImageUrl  string `json:"imageUrl"`
	} `json:"afterSaleImages"`
}

type RefundCreateRes struct {
	*CommonRes
	Data struct {
		AfterServiceId string `json:"afterServiceId"`
	} `json:"data"`
}
type RefundCancelReq struct {
	AfterServiceType string `json:"afterServiceType"`
	OutOrderId       string `json:"outOrderId"`
	CancelTime       string `json:"cancelTime"`
	CancelReasonType string `json:"cancelReasonType"`
	CancelReasonDesc string `json:"cancelReasonDesc"`
}

type RefundAuditResultReq struct {
}

type RefundAuditResultRes struct {
	*CommonRes
	Data struct {
		GomeAfterServiceId string `json:"gomeAfterServiceId"`
		AuditPassed        int    `json:"auditPassed"`
		AuditTime          string `json:"auditTime"`
		RejectedReasonType string `json:"rejectedReasonType"`
		RejectedReasonDesc string `json:"rejectedReasonDesc"`
		ReturnWareType     string `json:"returnWareType"`
		ServiceAddressInfo struct {
			Address string `json:"address"`
			Linkman string `json:"linkman"`
			Phone   string `json:"phone"`
		} `json:"serviceAddressInfo"`
	} `json:"data"`
}
type RefundSendReq struct {
	AfterServiceId      string `json:"afterServiceId"`
	OuterOrderId        string `json:"outerOrderId"`
	DeliveryCompanyCode string `json:"deliveryCompanyCode"`
	DeliveryCompanyName string `json:"deliveryCompanyName"`
	WaybillCode         string `json:"waybillCode"`
}

type RefundStatusRes struct {
	*CommonRes
	Data struct {
		AfterServiceId    string      `json:"afterServiceId"`
		CurrentStatus     string      `json:"currentStatus"`
		CurrentStatusTime interface{} `json:"currentStatusTime"`
		PastStatuses      []struct {
			Status     string `json:"status"`
			StatusTime string `json:"statusTime"`
		} `json:"pastStatuses"`
	} `json:"data"`
}

type RefundLogisticsRes struct {
	*CommonRes
	Data struct {
		AfterServiceId string `json:"afterServiceId"`
		CompanyCode    string `json:"companyCode"`
		CompanyName    string `json:"companyName"`
		CompanyPhone   string `json:"companyPhone"`
		WaybillCode    string `json:"waybillCode"`
		CourierName    string `json:"courierName"`
		CourierPhone   string `json:"courierPhone"`
		Tracks         []struct {
			TrackTime   string `json:"trackTime"`
			Description string `json:"description"`
		} `json:"tracks"`
	} `json:"data"`
}

//ReturnCount 商品可退货数量
func (refundGome) ReturnCount(ctx context.Context, req *ReturnCountReq) (res *ReturnCountRes, err error) {
	method := "alamein.afterSale.read.queryCanReturnCount"

	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//ServiceType 查询可服务类型及退回方式
func (refundGome) ServiceType(ctx context.Context, req *ServiceTypeReq) (res *ServiceTypeRes, err error) {
	method := "alamein.afterSale.read.queryCanServiceTypeAndReturnType"
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Create 申请
func (refundGome) Create(ctx context.Context, req *RefundCreateReq) (res *RefundCreateRes, err error) {
	method := "alamein.afterSale.write.submit"
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Cancel 取消售后订单
func (refundGome) Cancel(ctx context.Context, req *RefundCancelReq) (res *CommonRes, err error) {
	method := "alamein.afterSale.write.cancel"
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
func (refundGome) AuditResult(ctx context.Context, refundSn string) (res *RefundAuditResultRes, err error) {
	method := "alamein.afterSale.read.queryAuditResult"

	var req = g.Map{
		"afterServiceId": refundSn,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Send 顾客邮寄运单信息填写
func (refundGome) Send(ctx context.Context, req *RefundSendReq) (res *RefundSendReq, err error) {
	method := "alamein.afterSale.write.deliveryByCustomer"
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Status 状态查询
func (refundGome) Status(ctx context.Context, refundSn string) (res *RefundStatusRes, err error) {
	method := "alamein.afterSale.read.queryKeyStatus"

	var req = g.Map{
		"afterServiceId": refundSn,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

//Logistics 接收售后订单商品验货信息
func (refundGome) Logistics(ctx context.Context, refundSn string) (res *RefundLogisticsRes, err error) {
	method := "alamein.afterSale.read.queryLogisticsTrack"

	var req = g.Map{
		"afterServiceId": refundSn,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
