package upstream

import (
	"errors"
)

type AliMsgType string

type AliRefundStatus string
const (
	//产品下架
	AliProductExpire AliMsgType = "PRODUCT_RELATION_VIEW_PRODUCT_EXPIRE"
	// 产品删除
	AliProductExpire2 AliMsgType = "PRODUCT_RELATION_VIEW_PRODUCT_DELETE"
	// 产品审核下架
	AliProductExpire3 AliMsgType = "PRODUCT_RELATION_VIEW_PRODUCT_AUDIT"
	// 产品新增或修改
	AliProductModify AliMsgType = "PRODUCT_RELATION_VIEW_PRODUCT_NEW_OR_MODIFY"
	// 产品上架
	AliProductRepost AliMsgType = "PRODUCT_RELATION_VIEW_PRODUCT_REPOST"
	// 商品池&超买价变更消息
	AliProductPrice AliMsgType = "PRODUCT_RELATION_VIEW_EXIT_SUPERBUYER"
	// 订单发货
	AliOrderSendGoods AliMsgType = "ORDER_BUYER_VIEW_ANNOUNCE_SENDGOODS"
	// 订单确认收货
	AliOrderComfirm AliMsgType = "ORDER_BUYER_VIEW_ORDER_COMFIRM_RECEIVEGOODS"
	// 售中退款
	AliOrderRefund AliMsgType = "ORDER_BUYER_VIEW_ORDER_BUYER_REFUND_IN_SALES"
	// 售后退款
	AliOrderRefund2 AliMsgType = "ORDER_BUYER_VIEW_ORDER_REFUND_AFTER_SALES"

	// AliAfterSaleStateAgree AliAfterSaleStateAgree
	AliAfterSaleStateAgree AliRefundStatus = "SELLER_AGREE_REFUND_PROCOTOL"
	// AliAfterSaleStateAgree2 AliAfterSaleStateAgree2
	AliAfterSaleStateAgree2 AliRefundStatus = "SYSTEM_AGREE_REFUND_PROTOCOL"
	// AliAfterSaleStateRefuse AliAfterSaleStateRefuse
	AliAfterSaleStateRefuse AliRefundStatus = "SELLER_REJECT_REFUND"
	// AliAfterSaleStateRefuse2 AliAfterSaleStateRefuse2
	AliAfterSaleStateRefuse2 AliRefundStatus = "SELLER_REJECT_REFUND_PROCOTOL"
	// AliAfterSaleStateRefuse2 AliAfterSaleStateRefuse2
	AliAfterSaleStateRefuse3 AliRefundStatus = "SELLER_SEND_GOODS_CLOSE"


	// AliAfterSaleStateSuccess AliAfterSaleStateSuccess
	AliAfterSaleStateSuccess AliRefundStatus = "SELLER_AGREE_REFUND"
	// AliAfterSaleStateSuccess2 AliAfterSaleStateSuccess2
	AliAfterSaleStateSuccess2 AliRefundStatus = "SYSTEM_AGREE_REFUND"
)


// ToType ToType
func (c AliMsgType) ToType() (int, error) {
	switch c {
	case AliProductExpire, AliProductExpire2,AliProductExpire3:
		return ProductExpire, nil
	case AliProductModify:
		return ProductModify, nil
	case AliProductRepost:
		return ProductRepost, nil
	case AliProductPrice:
		return ProductPrice, nil
	case AliOrderSendGoods:
		return OrderSendgoods, nil
	case AliOrderComfirm:
		return OrderComfirmReceiveGoods, nil
	case AliOrderRefund, AliOrderRefund2:
		return RefundApply, nil
	default:
		return 0, errors.New("not allow type")
	}
}



// ToStatus ToStatus
func (c AliRefundStatus) ToStatus() (int, error) {
	switch c {
	case AliAfterSaleStateAgree, AliAfterSaleStateAgree2:
		return RefundAgree, nil
	case AliAfterSaleStateRefuse, AliAfterSaleStateRefuse2,AliAfterSaleStateRefuse3:
		return RefundRefuse, nil
	case AliAfterSaleStateSuccess, AliAfterSaleStateSuccess2:
		return RefundSuccess, nil
	default:
		return 0, errors.New("not allow type")
	}
}
//"refundsuccess" == Sockedata.Data.CurrentStatus && Sockedata.Data.RefundAction == "SYSTEM_AGREE_REFUND_PROTOCOL"
// IsSuccess IsSuccess
func (c AliRefundStatus) IsSuccess() bool {
	return c == AliAfterSaleStateSuccess || c == AliAfterSaleStateSuccess2 || c == AliAfterSaleStateAgree2
}
