package yz

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type logisticsLogic struct {
}

var Logistics = logisticsLogic{}

type LogisticsExpressRes struct {
	TraceId string `json:"trace_id"`
	Code    int    `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		AllExpress []struct {
			Display int    `json:"display"`
			Name    string `json:"name"`
			Id      int    `json:"id"`
		} `json:"allExpress"`
	} `json:"data"`
}

func (s logisticsLogic) Express(ctx context.Context) (res *LogisticsExpressRes, err error) {
	method := "youzan.logistics.express.get/3.0.0"
	result, err := server.requestApi(ctx, method, g.Map{})
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

type LogisticsConfirmReq struct {
	OutStype string `json:"out_stype"`      //物流id
	OutSid   string `json:"out_sid"`        //物流单号
	Oids     string `json:"oids,omitempty"` //子订单号
	Tid      string `json:"tid"`            //主订单号
}

func (s logisticsLogic) Confirm(ctx context.Context, req LogisticsConfirmReq) (res *OrderDetailRes, err error) {
	method := "youzan.logistics.online.confirm/3.0.0"
	result, err := server.requestApi(ctx, method, gconv.Map(req))
	if err != nil {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
