package sls

import (
	"github.com/aliyun/aliyun-log-go-sdk/producer"
	"github.com/gogf/gf/frame/g"
	"gitlab.jxhh.com/stbz/library.git/logs"
	"time"
)

const (
	ProjectDefault = "order"
	ProjectDis     = "dis"
	ProjectApi     = "api-system"
	ProjectMessage = "message-system"

	LogstoreDefault    = "post_msg"
	LogstoreOrder      = "orders"
	LogstoreDefaultErr = "go_error"
	LogstoreDisErr     = "dis_err"
	LogstoreMessage    = "push_msg"

	TopicDefault = "topic"
	TopicCloud   = "shopApi"
)

var producerInstance *producer.Producer

func init() {
	producerConfig := producer.GetDefaultProducerConfig()
	producerConfig.Endpoint = g.Cfg().GetString("aliLog.Endpoint")
	producerConfig.AccessKeyID = g.Cfg().GetString("aliLog.AccessKeyID")
	producerConfig.AccessKeySecret = g.Cfg().GetString("aliLog.AccessKeySecret")
	producerInstance = producer.InitProducer(producerConfig)
	producerInstance.Start()
}

func Createsls(project, logstore, topic,realIP string, addLogMap map[string]string) (err error) {
	sls := producer.GenerateLog(uint32(time.Now().Unix()), addLogMap)

	err = producerInstance.SendLog(project, logstore, topic, realIP, sls)
	if logs.CheckErr(err, "sls") {
		return
	}
	return
}

func Close() {
	producerInstance.SafeClose() // 安全关闭
}



