package tmv3

import (
	"context"
	openapi "github.com/alibabacloud-go/darabonba-openapi/v2/client"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
)

type Config struct {
	AppKey    string
	AppSecret string
}

var server *client.Client

const (
	PkgName     = "tmv3"
	Endpoint    = "linkedmall-distributor.cn-zhangjiakou.aliyuncs.com"
	RegionId    = "cn-zhangjiakou"
	PurchaserId = "PID2200006434"
)

func New(req *Config) {
	config := &openapi.Config{
		AccessKeyId:     tea.String(req.AppKey),
		AccessKeySecret: tea.String(req.AppSecret),
		RegionId:        tea.String(RegionId),
	}
	config.Endpoint = tea.String(Endpoint)
	server = &client.Client{}
	server, _ = client.NewClient(config)
	return
}

func Log(ctx context.Context, req interface{}, res interface{}, err error, start int64) {
	if err != nil {
		g.Log().Ctx(ctx).Cat(PkgName).Errorf("参数【%v】错误【%v】响应时间【%vms】", gjson.New(req).MustToJsonString(), err.Error(), gtime.TimestampMilli()-start)
	} else {
		g.Log().Ctx(ctx).Cat(PkgName).Infof("参数【%v】响应【%v】响应时间【%vms】", gjson.New(req).MustToJsonString(), gjson.New(res).MustToJsonString(), gtime.TimestampMilli()-start)
	}
}

type CommonRes struct {
	Code      string `json:"Code"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
}
