package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type OrderBeforeReq struct {
	FreightPayer     int               `json:"freightPayer,omitempty"`    //运费结算方式，不传默认为预付	1：预付	4：包邮结算
	InvoiceHeaderId  int               `json:"invoiceHeaderId,omitempty"` //发票抬头id
	InvoiceType      int               `json:"invoiceType,omitempty"`     //是否需要开票，不传默认为无需开票	0：无需开票	2：开票
	Province         string            `json:"province"`                  //收件人省份
	City             string            `json:"city"`                      //收件人城市
	District         string            `json:"district"`                  //收件人地区
	ExpCode          string            `json:"expCode"`                   //快递编码
	OrderDetailsList []OrderBeforeItem `json:"orderDetailsList"`
}

type OrderBeforeItem struct {
	Code string `json:"code"` //规格编码
	Num  int    `json:"num"`  //购买数量
}

type OrderBeforeRes struct {
	Code   int    `json:"code"`
	Msg    string `json:"msg"`
	Result struct {
		Freight          float64 `json:"freight"`
		GoodsMoneyAmount float64 `json:"goodsMoneyAmount"`
		PayMoney         float64 `json:"payMoney"`
	} `json:"result"`
	TraceId string `json:"traceId"`
}

// OrderBefore 订单运费
func (s *Config) OrderBefore(ctx context.Context, req OrderBeforeReq) (res *OrderBeforeRes, err error) {

	result, err := s.Post(ctx, "/open/xdxt/api/v2/order/orderFreightPreview", gconv.Map(req))
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	return
}
