package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type deliverIkc struct {
}

var Deliver = deliverIkc{}

type DeliverDetailRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          struct {
		OrderId      string `json:"orderId"`
		ShipmentList []struct {
			OrderDetailId        string `json:"orderDetailId"`
			ShipmentNo           string `json:"shipmentNo"`
			LogisticsCompany     string `json:"logisticsCompany"`
			LogisticsCompanyName string `json:"logisticsCompanyName"`
			LogisticsCode        string `json:"logisticsCode"`
		} `json:"shipmentList"`
	} `json:"data"`
}

func (*deliverIkc) Detail(ctx context.Context, orderId string) (res *DeliverDetailRes, err error) {
	method := "order/queryLogistics"
	result, err := post(ctx, method, g.Map{
		"orderId": orderId,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type DeliverTrackRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		LogisticsNo      string `json:"logisticsNo"`
		LogisticsCompany string `json:"logisticsCompany"`
		ExpressCompanyNo int    `json:"expressCompanyNo,omitempty"`
		TraceItemList    []struct {
			Time    string `json:"time"`
			Content string `json:"content"`
		} `json:"traceItemList"`
	} `json:"data"`
}

//Track 物流轨迹
func (*deliverIkc) Track(ctx context.Context, orderId string) (res *DeliverTrackRes, err error) {
	method := "delivery/order/track"
	result, err := post(ctx, method, g.Map{
		"orderId": orderId,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
