package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type addressGome struct {
}

var Address = addressGome{}

type AddressCommonRes struct {
	*CommonRes
	Data struct {
		AreaDtoList []struct {
			AreaCode   string `json:"areaCode"`
			AreaLevel  int    `json:"areaLevel"`
			ParentCode string `json:"parentCode"`
			AreaName   string `json:"areaName"`
			Status     int    `json:"status"`
		} `json:"areaDtoList"`
	} `json:"data"`
}

//Province 省
func (addressGome) Province(ctx context.Context) (res *AddressCommonRes, err error) {
	method := "alamein.basic.get.province"
	req := g.Map{}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

func (addressGome) City(ctx context.Context, pid string) (res *AddressCommonRes, err error) {
	method := "alamein.basic.get.city"
	req := g.Map{
		"parentCode": pid,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

func (addressGome) County(ctx context.Context, pid string) (res *AddressCommonRes, err error) {
	method := "alamein.basic.get.county"
	req := g.Map{
		"parentCode": pid,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

func (addressGome) Town(ctx context.Context, pid string) (res *AddressCommonRes, err error) {
	method := "alamein.basic.get.town"
	req := g.Map{
		"parentCode": pid,
	}
	result, err := server.requestApi(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
