package yonghui

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

var OrderRefund = new(orderRefund)

type orderRefund struct {
}

type OrderRefundApplyGoodsList struct {
	GoodsQty  int    `json:"goodsQty"`
	GoodsCode string `json:"goodsCode"`
}

type OrderRefundApplyReq struct {
	ThirdAfterSalesCode string                       `json:"thirdAfterSalesCode"`
	ThirdOrderCode      string                       `json:"thirdOrderCode"`
	CsxOrderCode        string                       `json:"csxOrderCode"`
	ReasonCode          int                          `json:"reasonCode"`
	ReasonMsg           string                       `json:"reasonMsg"`
	Images              []string                     `json:"images"`
	GoodsList           []*OrderRefundApplyGoodsList `json:"goodsList"`
}

type OrderRefundApplyRes struct {
	Success string `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    struct {
		AftersalesInfos []struct {
			AfterSalesCode       string `json:"afterSalesCode"`
			AfterSalesGoodsInfos []struct {
				AssembleGoodsCode string `json:"assembleGoodsCode"`
				GoodsCode         string `json:"goodsCode"`
				GoodsName         string `json:"goodsName"`
			} `json:"afterSalesGoodsInfos"`
		} `json:"aftersalesInfos"`
	} `json:"data"`
}

/**
申请售后
*/
func (s *orderRefund) Apply(ctx context.Context, req *OrderRefundApplyReq) (res *OrderRefundApplyRes, err error) {

	result, err := post(ctx, "com.csx.order-aftersales-apply.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderRefundSubmitLogisticsReq struct {
	AfterSalesCode string `json:"afterSalesCode"`
	ShipperCode    string `json:"shipperCode"`
	LogisticsCode  string `json:"logisticsCode"`
}

type OrderRefundSubmitLogisticsRes struct {
	Success string `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    string `json:"data"`
}

/**
更新物流
*/
func (s *orderRefund) SubmitLogistics(ctx context.Context, req *OrderRefundSubmitLogisticsReq) (res *OrderRefundSubmitLogisticsRes, err error) {

	result, err := post(ctx, "com.csx.order-aftersales-submit-logistics.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderRefundCancelReq struct {
	ThirdAfterSalesCode string `json:"thirdAfterSalesCode"`
	AfterSalesCode      string `json:"afterSalesCode"`
}

type OrderRefundCancelRes struct {
	Success string `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    string `json:"data"`
}

/**
取消售后
*/
func (s *orderRefund) Cancel(ctx context.Context, req *OrderRefundCancelReq) (res *OrderRefundCancelRes, err error) {

	result, err := post(ctx, "com.csx.order-cancelAftersales.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderRefundQueryReq struct {
	ThirdAfterSalesCode string `json:"thirdAfterSalesCode"`
	AfterSalesCode      string `json:"afterSalesCode"`
}

type OrderRefundQueryRes struct {
	Success string `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		CsxOrderCode           string `json:"csxOrderCode"`
		ThirdOrderCode         string `json:"thirdOrderCode"`
		AfterSalesCode         string `json:"afterSalesCode"`
		ThirdAfterSalesCode    string `json:"thirdAfterSalesCode"`
		RefundFreight          string `json:"refundFreight"`
		RefundTotalAmt         string `json:"refundTotalAmt"`
		RefundGoodsAmt         string `json:"refundGoodsAmt"`
		NeedReturnGoods        int    `json:"needReturnGoods"`
		AfterSalesType         int    `json:"afterSalesType"`
		ReasonCode             int    `json:"reasonCode"`
		ReasonMsg              string `json:"reasonMsg"`
		AfterSalesImages       string `json:"afterSalesImages"`
		Remark                 string `json:"remark"`
		ReturnGoodsStatus      int    `json:"returnGoodsStatus"`
		RefundStatus           int    `json:"refundStatus"`
		AuditType              int    `json:"auditType"`
		AfterSalesStatus       int    `json:"afterSalesStatus"`
		RecipientName          string `json:"recipientName"`
		RecipientPhone         string `json:"recipientPhone"`
		RecipientAddress       string `json:"recipientAddress"`
		CreateTime             string `json:"createTime"`
		EndTime                string `json:"endTime"`
		AfterSalesGoodsDetails []struct {
			GoodsCode         string `json:"goodsCode"`
			GoodsName         string `json:"goodsName"`
			ReturnCount       int    `json:"returnCount"`
			GoodsTotalPrice   string `json:"goodsTotalPrice"`
			GoodsFreightPrice string `json:"goodsFreightPrice"`
			AssembleGoodsCode string `json:"assembleGoodsCode,omitempty"`
		} `json:"afterSalesGoodsDetails"`
	} `json:"data"`
}

/**
查询售后
*/
func (s *orderRefund) Query(ctx context.Context, req *OrderRefundQueryReq) (res *OrderRefundQueryRes, err error) {

	result, err := post(ctx, "com.csx.order-aftersales-detail-query.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderRefundListReq struct {
	CsxOrderCode   string `json:"csxOrderCode"`
	ThirdOrderCode string `json:"thirdOrderCode"`
}

type OrderRefundListRes struct {
	Success string `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    struct {
		CsxOrderCode               string `json:"csxOrderCode"`
		ThirdOrderCode             string `json:"thirdOrderCode"`
		AftersalesDetailRespVoList []struct {
			CsxOrderCode           string `json:"csxOrderCode"`
			ThirdOrderCode         string `json:"thirdOrderCode"`
			AfterSalesCode         string `json:"afterSalesCode"`
			ThirdAfterSalesCode    string `json:"thirdAfterSalesCode"`
			RefundFreight          string `json:"refundFreight"`
			RefundTotalAmt         string `json:"refundTotalAmt"`
			RefundGoodsAmt         string `json:"refundGoodsAmt"`
			NeedReturnGoods        int    `json:"needReturnGoods"`
			AfterSalesType         int    `json:"afterSalesType"`
			ReasonCode             int    `json:"reasonCode"`
			ReasonMsg              string `json:"reasonMsg"`
			AfterSalesImages       string `json:"afterSalesImages"`
			Remark                 string `json:"remark"`
			ReturnGoodsStatus      int    `json:"returnGoodsStatus"`
			RefundStatus           int    `json:"refundStatus"`
			AuditType              int    `json:"auditType"`
			AfterSalesStatus       int    `json:"afterSalesStatus"`
			RecipientName          string `json:"recipientName"`
			RecipientPhone         string `json:"recipientPhone"`
			RecipientAddress       string `json:"recipientAddress"`
			CreateTime             string `json:"createTime"`
			EndTime                string `json:"endTime"`
			AfterSalesGoodsDetails []struct {
				GoodsCode         string `json:"goodsCode"`
				GoodsName         string `json:"goodsName"`
				ReturnCount       int    `json:"returnCount"`
				GoodsTotalPrice   string `json:"goodsTotalPrice"`
				GoodsFreightPrice string `json:"goodsFreightPrice"`
				AssembleGoodsCode string `json:"assembleGoodsCode,omitempty"`
			} `json:"afterSalesGoodsDetails"`
		} `json:"aftersalesDetailRespVoList"`
	} `json:"data"`
}

/**
查询售后
*/
func (s *orderRefund) List(ctx context.Context, req *OrderRefundListReq) (res *OrderRefundListRes, err error) {

	result, err := post(ctx, "com.csx.order-aftersales-list-query.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
