package yonghui

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

var Goods = new(goods)

type goods struct {
}

type GoodsListReq struct {
	GoodsCode string `json:"goodsCode"`
	StartNum  int    `json:"startNum"`
	PageSize  int    `json:"pageSize"`
}

type GoodsListRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		LineNo     int    `json:"lineNo"`
		GoodsCode  string `json:"goodsCode"`
		GoodsName  string `json:"goodsName"`
		GoodsUnit  string `json:"goodsUnit"`
		GoodsSpec  string `json:"goodsSpec"`
		GoodsClass struct {
			FirstClass    string `json:"firstClass"`
			FirstClassId  string `json:"firstClassId"`
			SecondClass   string `json:"secondClass"`
			SecondClassId string `json:"secondClassId"`
		} `json:"goodsClass"`
		GoodsPic struct {
			SmallPicUrl  string `json:"smallPicUrl"`
			MiddlePicUrl string `json:"middlePicUrl"`
			MainPicUrl   string `json:"mainPicUrl"`
			DetailPicUrl string `json:"detailPicUrl"`
		} `json:"goodsPic"`
		GoodsTaxRate        string        `json:"goodsTaxRate"`
		GoodsTaxCode        string        `json:"goodsTaxCode"`
		MinLimit            string        `json:"minLimit"`
		ComposeGoodsTaxInfo []interface{} `json:"composeGoodsTaxInfo"`
		BrandName           string        `json:"brandName"`
		DeliveryType        int           `json:"deliveryType"`
		DeliveryAreas       string        `json:"deliveryAreas"`
		SalesStatus         int           `json:"salesStatus"`
		GoodsProposalPrice  string        `json:"goodsProposalPrice"`
		GoodsFreightType    string        `json:"goodsFreightType"`
		GoodsLockPrice      string        `json:"goods_lock_price"` //临时获取的价格，用于订单操作
		GoodsLockStock      string        `json:"goods_lock_stock"` //临时获取的库存，用于订单操作
		GoodsStatus         int           `json:"goodsStatus"`
	} `json:"data"`
}

/**
  商品列表
*/
func (s *goods) List(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {

	result, err := post(ctx, "com.csx.goods-detail.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsBaseReq struct {
	GoodsCode string `json:"goodsCode"`
}

type GoodsPriceRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		GoodsCode  string `json:"goodsCode"`
		GoodsPrice int    `json:"goodsPrice"`
	} `json:"data"`
}

/**
商品价格
*/
func (s *goods) Price(ctx context.Context, req *GoodsBaseReq) (res *GoodsPriceRes, err error) {

	result, err := post(ctx, "com.csx.goods-price.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsQtyReq struct {
	Province     string `json:"province"`
	City         string `json:"city"`
	Area         string `json:"area"`
	Address      string `json:"address"`
	GoodsCode    string `json:"goodsCode"`
	DeliveryType string `json:"deliveryType"`
}

type GoodsQtyRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		GoodsCode string `json:"goodsCode"`
		GoodsQty  int    `json:"goodsQty"`
	} `json:"data"`
}

/**
商品库存
*/
func (s *goods) GoodsQty(ctx context.Context, req *GoodsQtyReq) (res *GoodsQtyRes, err error) {

	result, err := post(ctx, "com.csx.inventory-search.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsQtyAreaReq struct {
	Type       string `json:"type"`
	Area       string `json:"area"`
	GoodsCodes string `json:"goodsCodes"`
}

type GoodsQtyAreaRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		GoodsCode   string `json:"goodsCode"`
		SalesStatus int    `json:"salesStatus"`
		GoodsStatus int    `json:"goodsStatus"`
	} `json:"data"`
}

/**
商品库存接口(地址映射)
*/
func (s *goods) GoodsQtyQtyArea(ctx context.Context, req *GoodsQtyAreaReq) (res *GoodsQtyAreaRes, err error) {

	result, err := post(ctx, "com.csx.inventory-search-area.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type GoodsShelvesRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		GoodsCode   string `json:"goodsCode"`
		SalesStatus int    `json:"salesStatus"`
		GoodsStatus int    `json:"goodsStatus"`
	} `json:"data"`
}

/**
商品上下架
*/
func (s *goods) GoodsShelves(ctx context.Context, req *GoodsBaseReq) (res *GoodsShelvesRes, err error) {

	result, err := post(ctx, "com.csx.goods-shelves.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
