package yonghui

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

var Believe = new(believe)

type believe struct {
}

type BelieveRechargeInfo struct {
	CreditBalance string `json:"credit_balance"`
	CreditType    string `json:"credit_type"`
	Remark        string `json:"remark"`
	Telephone     string `json:"telephone"`
	UserName      string `json:"user_name"`
}

type BelieveRechargeReq struct {
	BatchCode    string                 `json:"batch_code"`
	RechargeInfo []*BelieveRechargeInfo `json:"recharge_info"`
}

type BelieveRechargeRes struct {
	Success bool        `json:"success"`
	Code    string      `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

/**
授信充值
*/
func (s *believe) Recharge(ctx context.Context, req *BelieveRechargeReq) (res *BelieveRechargeRes, err error) {
	result, err := post(ctx, "com.csx.credit-recharge.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type BelieveBalanceReq struct {
	CreditType string   `json:"credit_type"`
	Telephones []string `json:"telephones"`
}

type BelieveBalanceRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    g.Map  `json:"data"`
}

/**
查询授信
*/
func (s *believe) Balance(ctx context.Context, req *BelieveBalanceReq) (res *BelieveBalanceRes, err error) {
	result, err := post(ctx, "com.csx.credit-balance-search.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type BelieveRechargeRollbackReq struct {
	BatchCode     string `json:"batch_code"`
	Telephone     string `json:"telephone"`
	CreditType    string `json:"credit_type"`
	CreditBalance string `json:"credit_balance"`
	Remark        string `json:"remark"`
}

type BelieveRechargeRollbackRes struct {
	Success bool        `json:"success"`
	Code    string      `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

/**
撤销充值
*/
func (s *believe) RechargeRollback(ctx context.Context, req *BelieveRechargeRollbackReq) (res *BelieveRechargeRollbackRes, err error) {
	result, err := post(ctx, "com.csx.credit-recharge-rollback.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
