package yonghui

import (
	"github.com/gogf/gf/crypto/gmd5"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"time"
)

import (
	"context"
)

var server *Config

//永辉
const pkgName = "yonghui"

type Config struct {
	Auth    string
	SignKey string
	ApiUrl  string
}

func New(req *Config) {
	server = req
	return
}

func sign(data string) string {
	signString := data + server.SignKey
	res := gmd5.MustEncryptString(signString)
	return res
}

func post(ctx context.Context, method string, req interface{}) (res string, err error) {

	Start := gtime.TimestampMilli()
	param := gjson.New(req)
	formData := g.Map{
		"auth":   server.Auth,
		"method": method,
		"data":   param.MustToJsonString(),
		"sign":   sign(param.MustToJsonString()),
	}

	Url := server.ApiUrl
	Request := g.Client()
	Request.SetHeader("Content-Type", "application/x-www-form-urlencoded")

	resp, err := Request.Timeout(time.Second*10).Post(Url, formData)
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", Url)
		if err != nil {
			g.Log().Ctx(ctx).Cat(pkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v ms】", param.MustToJsonString(), err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v ms】", param.MustToJsonString(), res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}
