package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type orderWpc struct {
}

var Order = orderWpc{}

type OrderListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
}
type OrderListRes struct {
}

type OrderCreateReq struct {
	ChannelId       string `json:"vopChannelId"`
	UserNumber      string `json:"userNumber"`
	AreaId          string `json:"areaId,omitempty"`
	ProvinceName    string `json:"provinceName,omitempty"`
	CityName        string `json:"cityName,omitempty"`
	AreaName        string `json:"areaName,omitempty"`
	TownName        string `json:"townName,omitempty"`
	Address         string `json:"address"`
	Consignee       string `json:"consignee"`
	Mobile          string `json:"mobile"`
	OrderSn         string `json:"channelOrderSn"`
	IsUseCipher     string `json:"isUseCipher"`
	AddressCipher   string `json:"addressCipher,omitempty"`   //详细地址加密, 加密类型:RSA2048
	ConsigneeCipher string `json:"consigneeCipher,omitempty"` //收件人加密, 加密类型:RSA2048
	MobileCipher    string `json:"mobileCipher,omitempty"`    //收件人手机号加密, 加密类型:RSA2048
	SizeInfo        map[string]uint `json:"sizeInfo"`
	ClientIp     	string `json:"clientIp"`
	TraceId         string `json:"traceId"`
}

type OrderCreateSizeInfo struct {
	AdID       int    `json:"adId"`
	SizeID     int64  `json:"sizeId"`
	SizeNum    int    `json:"sizeNum"`
	CouponCode string `json:"couponCode"`
}

type OrderCreateRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		Orders []struct {
			OrderSn     string
			IsUseCoupon bool
		}
		CouponList []struct {
			CouponNo        string
			CouponSn        string
			OrderSn         string
			GetCouponStatus int
			GetCouponReason string
			UseCouponStatus int
			UseCouponReason string
		}
	} `json:"result"`
}
type OrderDetailReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
	OrderSnList string `json:"orderSnList"`
}
type OrderPayReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn string `json:"orderSn"`
	ClientIp string `json:"clientIp"`
}
type OrderPayRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        struct{
		ApplySuccess bool `json:"applySuccess"`
		FailReason string `json:"failReason"`
	}
}
type OrderDetailRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        []struct{
		ParentOrderSn string
		ChildOrderSnList []struct{
			OrderSn string
			StatusName string
			TransportNo string
			TransportName string
			Goods []struct{
				GoodFullId string
				SizeId string
				Price string
			}
			StatusCode int //订单状态Code--[1:"待支付"},{2:"待发货"},{3:"已发货"},{4:"已完成"},{5:"已取消"},{6:"拒收"},{7:"已签收"}]
			RefundStatus int //退款状态, 0:未退款 1:已退款
			ShippingFee string //订单运费
			RealPayTotal string//订单实付金额
			TransportList []struct{
				TransportNo string
				TransportName string
				DetailList []struct{
					GoodFullId string
					SizeId string
					Amount int
				}
			}
		}
	} `json:"result"`
}
type OrderGetSizeStatusReq struct {
	AreaId       string `json:"areaId"`
	SizeIds       string `json:"sizeIds"`
	ChannelId       string `json:"vopChannelId"`
	UserNumber      string `json:"userNumber"`
}
type OrderGetSizeStatusRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		List []struct{
			GoodFullId string
			SizeId     string
			SizeName     string
			Stock     int
			Type     string
			GoodOnline int
			BuyMaxNum int
		}
	}
}
//List 列表
func (orderWpc) List(ctx context.Context, req OrderListReq) (res *OrderListRes, err error) {
	method := "getSimpleOrderListV2"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}



//订单信息
func (orderWpc) Detail(ctx context.Context, req OrderDetailReq) (res *OrderDetailRes, err error) {
	method := "getOrderInfoList"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}


//Create 下单
func (orderWpc) Create(ctx context.Context, req OrderCreateReq) (res *OrderCreateRes, err error) {
	method := "orderCreate"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}

///获取规格状态
func (orderWpc) GetAddr(ctx context.Context, req OrderGetSizeStatusReq) (res *OrderGetSizeStatusRes, err error) {
	method := "selectAddress"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}
///代扣
func (orderWpc) ApplyPayment(ctx context.Context, req *OrderPayReq) (res *OrderPayRes, err error) {
	method := "applyPayment"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}