package tmv3

import (
	"context"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type LogisticsTraceReq struct {
	OrderId string
}

type LogisticsTraceRes struct {
	RequestId          string `json:"requestId"`
	LogisticsOrderList []struct {
		DataProvider      string `json:"dataProvider"`
		DataProviderTitle string `json:"dataProviderTitle"`
		Goods             []struct {
			GoodName  string `json:"goodName"`
			ProductId string `json:"productId"`
			Quantity  int    `json:"quantity"`
		} `json:"goods"`
		LogisticsCompanyCode string `json:"logisticsCompanyCode"`
		LogisticsCompanyName string `json:"logisticsCompanyName"`
		LogisticsDetailList  []struct {
			OcurrTimeStr string `json:"ocurrTimeStr"`
			StanderdDesc string `json:"standerdDesc"`
		} `json:"logisticsDetailList"`
		MailNo string `json:"mailNo"`
	} `json:"logisticsOrderList"`
}

// Trace  查询订单物流信息
func (s logisticsTm) Trace(ctx context.Context, req LogisticsTraceReq) (res *LogisticsTraceRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ListLogisticsOrders")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	r, err := server.ListLogisticsOrders(tea.String(req.OrderId))
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
